#include "mbed.h"

Timeout TrigOffTimeOut;
Timer EchoTime;

DigitalOut Led1(PA_8);
DigitalOut Led2(PC_7);
DigitalOut TRIG(PB_6);

InterruptIn ECHO(PA_9);

// Prototypes
void StartTrig();
void Echo_Rise();
void Echo_Fall();
void StopTrig();


// Variables
static int EchoTimeuS = 0;

void Echo_Rise()
{
//Start timer
EchoTime.start();
}

void Echo_Fall()
{
//Stop timer
EchoTime.stop();
//lagre echo tid i variabel
EchoTimeuS = EchoTime.read_us();
// Reset timer
EchoTime.reset();

//sett leds 
if(EchoTimeuS <  638 && EchoTimeuS >  522){ Led1=1; }   else { Led1=0; }
if(EchoTimeuS < 6380 && EchoTimeuS > 5220){ Led2=1; } else { Led2=0; }

//restart trig sekvens
StartTrig();
}

void StartTrig()
{
// Sett TRIG høy
TRIG=1;
//sett timeout for TRIG lav (10uS)
TrigOffTimeOut.attach_us(&StopTrig, 10);
}

void StopTrig()
{
TRIG=0;
}

int main() {

        Led1=0;
        Led2=0;
        TRIG=0;
        
        ECHO.rise(&Echo_Rise);
        ECHO.fall(&Echo_Fall);
        
        //Start sekvens
        StartTrig();
        
        while(1)
        {
        
        }
}