#include "mbed.h"   // Basic Library required for onchip peripherals
#include "LM75B.h"  // Library for LM75B I2C based Temperature sensor 
#include "C12832.h"   // Library for SPI based LCD
#include <cstdlib>
//#include "USBSerial.h"
 
/* Create Objects */ 
LM75B tmp(p28,p27);         // Initialize I2C pins for Temperature Sensor
Serial serial(USBTX,USBRX);
//USBSerial serial; //use this for a virtual com port on D+ & D-
AnalogIn Pot1(p19);                 // Initialize Pot1 object with Analog input
C12832 lcd(p5, p7, p6, p8, p11);    // Initialize lcd object with SPI pins
DigitalOut myled(LED1);
DigitalOut myled1(LED2);
PwmOut r (p23);  // Create PWM object r for Red LED pin p23
PwmOut g (p24);  // Create PWM object g for Green LED pin p24
PwmOut b (p25);  // Create PWM object b for Blue LED pin p25
 
char ser_buf[50],i,data_OK;
 
void Serial_parser();
void Serial_get_data();
 
/* Main Program */ 
int main() {
    float board_temp,cpot,fpot;

    r.period(0.001);  // Periods in seconds which is 1KHz PWM freq
    r = 1;
    g = 1;
    b = 1;
    
    lcd.cls();                 // Clear LCD Screen
    lcd.locate(0,3);           // Start from x=0 and y=3 pixels
    lcd.printf("mbed application board!"); // print string on LCD
    
    serial.attach(&Serial_get_data);
    /**
    * Configure Terminal at 9600 8N1 configuration
    * In linux COM port would be /dev/ttyACM0 
    * or to find out use "dmesg" command
    */
    while (1) {
        board_temp = tmp; // read temperature
        fpot = (float)Pot1.read_u16();
        cpot = 3300*(fpot/65535);
        serial.printf("pot1:%.2fmV_temperature:%.2fC;",cpot,board_temp); // Display temperature on Terminal          
        wait(1.0);        // 1 sec delay
    }
}

void Serial_parser()                           // Parser function for Data in the Serial buffer
{
    float Rcnv,Gcnv,Bcnv;
    
    if(data_OK) { //if everything is ok, data are available
        switch (ser_buf[0]) {
            case 'L':
                if((ser_buf[1]=='O') && (ser_buf[2]=='N')) { //The command for turning led on is "LON
                    myled = 1;
                }
                if((ser_buf[1]=='O') && (ser_buf[2]=='F') && (ser_buf[3]=='F')) { //the command for turning led off is "LOFF"
                    myled = 0;
                }
                break;
                
            case 'R':
                Rcnv = atof(&ser_buf[1]);
                r = 1.0 - (Rcnv/100);
                break;
                
            case 'G':
                Gcnv = atof(&ser_buf[1]);
                g = 1.0 - (Gcnv/100);                
                break;
                
            case 'B':
                Bcnv = atof(&ser_buf[1]);
                b = 1.0 - (Bcnv/100);                
                break;                                
                
            default:
            serial.printf("Command unkonwn \r\n");
        }
        data_OK = 0; // we did what we have to do
        for(int x=0; x<50; x++) ser_buf[x] = 0; //clear buffer
    }
}
 
 
void Serial_get_data()                   // Aquiring serial data
{
    if(serial.readable()) {  //if data are available - uncomment this for mini usb MBED
//      if(serial.available()) { //use this for virtual com port on D+ & D-
      
        ser_buf[i]=serial.getc();
 
        if (ser_buf[i] == '\r') { //if CR is recieved, we ended the sentence
            data_OK = 1; //we have something to parse
            i=0; //reset the counter
 
            Serial_parser(); //call the parser function
        } else {
            serial.putc(ser_buf[i]);
            i++;
            if(i>50) i=0; //we need only a few characters to turn a led on or off
        }
    }
}

