#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "C12832_lcd.h"

C12832_LCD lcd; //Graphics LCD
EthernetInterface eth;
NTPClient ntp;

static const char* mbedIp       = "192.168.0.160";  //IP
static const char* mbedMask     = "255.255.255.0";  // Mask
static const char* mbedGateway  = "192.168.0.254";    //Gateway

int main()
{
    EthernetInterface eth;
    eth.init(mbedIp,mbedMask,mbedGateway); //Use  these parameters for static IP
    eth.connect();
    lcd.printf("Connected! IP Address is %s\n", eth.getIPAddress());
    
    lcd.cls();
    lcd.printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0) {
        lcd.printf("Set time successfully\r\n");
        while(1) {
            lcd.cls();
            lcd.locate(0,0);
            time_t ctTime;
            ctTime = time(NULL);
            lcd.printf("%s\r\n", ctime(&ctTime));
            lcd.printf("Current Time (UTC)");
            wait(1);
        }
    } else {
        lcd.printf("NTP Error\r\n");
    }

    eth.disconnect();

    while(1) {
    }
}
