#include "mbed.h"

/**  A GPS interface for reading from a Globalsat EM-406 GPS Module */
class GPS {
public:

    /** Create the GPS interface, connected to the specified serial port
     */    
    GPS(PinName tx, PinName rx);
    
    /** Sample the incoming GPS data, returning whether there is a lock
     * 
     * @return 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
     */
    int sample();
    float trunc(float v);
    /** The longitude (call sample() to set) */
    float longitude;

    /** The latitude (call sample() to set) */
    float latitude;
    int sate_in_view,lock;
    float time;
    
    
private:
    
    void getline();
    
    Serial _gps;
    char msg[256];

};