#include "mbed.h"     // Basic Library required for onchip peripherals
#include "C12832.h"   // Library for SPI based LCD
 
/* Create Objects */ 
C12832 lcd(p5, p7, p6, p8, p11);    // Initialize lcd object with SPI pins
AnalogIn Pot1(p19);                 // Initialize Pot1 object with Analog input

/* Main Program */
int main()
{    
    lcd.cls();                  // Clear LCD Screen
    lcd.locate(0,3);            // Start from x=0 and y=3 pixels
    lcd.printf("ADC Value:");   // Print message for ADC value
    
    while(1)
    {
        lcd.locate(0,15);       // Start from x=0 and y=15 pixels
        lcd.printf("%d",Pot1.read_u16()); // get value of pot 1 in 16bits
        wait(0.2);              // 200 ms delay
        lcd.locate(0,15);       // Start from x=0 and y=15 pixels
        lcd.printf("       ");  // Erase value for new one to be updated
    }
}