#include "mbed.h"       // Basic Library required for onchip peripherals
#include "MMA7660.h"    // Library for MMA7660 3-axis accelerometer
#include "C12832.h"     // Library for SPI based LCD
 
/* Create Objects */  
C12832 lcd(p5, p7, p6, p8, p11);    // Initialize lcd object with SPI pins
MMA7660 MMA(p28, p27);              // Initialize I2C pins for MMA object

/* Main Program */
int main() {  
    lcd.cls();              // Clear LCD Screen
    lcd.locate(0,3);        // Start from x=0 and y=3 pixels
    lcd.printf("Accelerometer Value:"); // Display Accelerometer msg on LCD
        
    while(1) {
        lcd.locate(0,15);   // Start from x=0 and y=15 pixels
        lcd.printf("x=%5.4f  y=%5.4f",MMA.x(),MMA.y()); // Print x and y values max will be 1
        wait(0.1);          // 1 sec delay
    }
}
