#include "mbed.h"   // Basic Library required for onchip peripherals
#include "LM75B.h"  // Library for LM75B I2C based Temperature sensor

/* Create Objects */ 
LM75B tmp(p28,p27);         // Initialize I2C pins for Temperature Sensor
Serial pc(USBTX, USBRX);    // Map USBTX and USBRX pins as serial out and in

/* Main Program */
int main ()
{
    float board_temp;

    /**
    * Configure Terminal at 9600 8N1 configuration
    * In linux COM port would be /dev/ttyACM0 
    * or to find out use "dmesg" command
    */
    while (1) {
        board_temp = tmp; // read temperature
        pc.printf("Board Temperature = %.2f\n\r",board_temp); // Display temperature on Terminal
        wait(1.0);        // 1 sec delay
    }
}
