/* Star Wars Song Selector
 * -----------
 *
 * Program to choose between two melodies by using a potentiometer and a piezo buzzer.
 * Inspired by: https://code.google.com/p/rbots/source/browse/trunk/StarterKit/Lesson5_PiezoPlayMelody/Lesson5_PiezoPlayMelody.pde
 */
 
// TONES //
// Defining the relationship between note, period & frequency. 
 
// period is in microsecond so P = 1/f * (1E6)
#ifndef TONE_H
#define TONE_H
#include "mbed.h" 
#define  c3    7634
#define  d3    6803
#define  e3    6061
#define  f3    5714
#define  g3    5102
#define  a3    4545
#define  b3    4049
#define  c4    3816    // 261 Hz 
#define  d4    3401    // 294 Hz 
#define  e4    3030    // 329 Hz 
#define  f4    2865    // 349 Hz 
#define  g4    2551    // 392 Hz 
#define  a4    2272    // 440 Hz 
#define  a4s   2146
#define  b4    2028    // 493 Hz 
#define  c5    1912    // 523 Hz
#define  d5    1706
#define  d5s   1608
#define  e5    1517    // 659 Hz
#define  f5    1433    // 698 Hz
#define  g5    1276
#define  a5    1136
#define  a5s   1073
#define  b5    1012
#define  c6    955
 
#define  R     0      // Define a special note, 'R', to represent a rest
 
#define buzz PTC8 
// SETUP //
 
void imperial_march();
 #endif