#include "tone.h"

DigitalOut speakerOut(buzz);   // Set up speaker on digital pin 7

// MELODIES and TIMING //
//  melody[] is an array of notes, accompanied by beats[],
//  which sets each note's relative length (higher #, longer note)

// Melody 1: Star Wars Imperial March
int melody1[] = {  a4, R,  a4, R,  a4, R,  f4, R, c5, R,  a4, R,  f4, R, c5, R, a4, R,  e5, R,  e5, R,  e5, R,  f5, R, c5, R,  g5, R,  f5, R,  c5, R, a4, R};
int beats1[]  = {  50, 20, 50, 20, 50, 20, 40, 5, 20, 5,  60, 10, 40, 5, 20, 5, 60, 80, 50, 20, 50, 20, 50, 20, 40, 5, 20, 5,  60, 10, 40, 5,  20, 5, 60, 40};

// Melody 2: Star Wars Theme
int melody2[] = {  f4,  f4, f4,  a4s,   f5,  d5s,  d5,  c5, a5s, f5, d5s,  d5,  c5, a5s, f5, d5s, d5, d5s,   c5};
int beats2[]  = {  21,  21, 21,  128,  128,   21,  21,  21, 128, 64,  21,  21,  21, 128, 64,  21, 21,  21, 128 };

int MAX_COUNT = sizeof(melody1) / 2; // Melody length, for looping.
long tempo = 10000; // Set overall tempo
int pause = 1000; // Set length of pause between notes
int rest_count = 1; // Loop variable to increase Rest length (BLETCHEROUS HACK; See NOTES)
// Initialize core variables
int toneM = 0;
int beat = 0;
long duration  = 0;
// PLAY TONE  //
// Pulse the speaker to play a tone for a particular duration
void imperial_march()
{
    for (int i=0; i<36; i++) {
        toneM = melody1[i];
        beat = beats1[i];
        duration = beat * tempo; // Set up timing
        long elapsed_time = 0;
        if (toneM > 0) { // if this isn't a Rest beat, while the tone has
            //  played less long than 'duration', pulse speaker HIGH and LOW
            while (elapsed_time < duration) {
                speakerOut=1;
                wait_us(toneM / 2);
                speakerOut=0;
                wait_us(toneM / 2);
                elapsed_time += (toneM);
            }
        } else { // Rest beat; loop times delay
            for (int j = 0; j < rest_count; j++) { // See NOTE on rest_count
                wait_us(duration);
            }
        }
    }
}

