#include "bt_shell_f.h"
//#include "keybindings.h"
//the following functions are for the python interface

//save a struct that indicates which data is to be returned
interface_f iface_f;
//mandatory tiny shell output function

int char_received1=0;
void bt_shell_f_run()
{
    char buffer[12];
    bt.lock();
    if(bt.readable()) {
        bt.gets(buffer,3);
        char_received1=buffer[0]-'0';
        bt.unlock();
        if(buffer[1]=='S') {
            bt.lock();
            stdio_mutex.lock();
            bt.printf("%d;%d;%d;%d;%d;%d;",
                      UL_rR,UL_R,UL_F,UL_L,UL_rL,UL_B);
            stdio_mutex.unlock();
            bt.unlock();
        } else if(buffer[1]=='H') {
            Lmotor_speed= 0;
            Rmotor_speed = 0;
            Led_off();
        } else if(buffer[1]=='L') {
            Led_on();
        } else if(buffer[1]=='l') {

            Led_off();
        } else if(buffer[1]=='w') {
            bt.gets(buffer,char_received1);
            int Left_m_value = ((buffer[0]-'0')*100 + (buffer[1]-'0')*10 + (buffer[2]-'0')*1);
            int Right_m_value= ((buffer[4]-'0')*100 + (buffer[5]-'0')*10 + (buffer[6]-'0')*1);
            Lmotor_speed= (Left_m_value-200)*3.5;
            Rmotor_speed = (Right_m_value-200)*3.5;
        } else if(buffer[1]=='B') {
            bt.gets(buffer,char_received1);
            int buzzer_time = ((buffer[0]-'0')*1000 + (buffer[1]-'0')*100 + (buffer[2]-'0')*10 + (buffer[3]-'0')*1);
            int frequency= ((buffer[5]-'0')*100 + (buffer[6]-'0')*10 + (buffer[7]-'0')*1);
            pl_buzzer(frequency, buzzer_time);
        } else if(buffer[1]=='D') {

            bt.lock();
            bt.printf("%lf;%lf",
                      ldrread1(),ldrread2());
            bt.unlock();
        } else if(buffer[1]=='O') {
            int obstacle_found=0;
            if(UL_F<250) {
                obstacle_found=1;
            } else {
                obstacle_found=0;
            }
            bt.lock();
            bt.printf("%d",
                      obstacle_found);
            bt.unlock();
        } else if(buffer[1]=='A') {
            bt.lock();
            stdio_mutex.lock();
            bt.printf("%d;%d;%d",
                      Encoder_x,Encoder_x,heading);
            stdio_mutex.unlock();
            bt.unlock();
        } else if(buffer[1]=='<'  && buffer[0] == '<') {
            bt.gets(buffer,3);
            if(buffer[1] =='E')
                bt.printf(">>1B");
            else if (buffer[1] =='O') {
                bt.gets(buffer, 2);
                if(buffer[0]=='A') {
                    Selected_robot='A';
                    imperial_march();
                } else if(buffer[0]=='F') {
                    Selected_robot='F';
                    Led_on();
                }
            }

        } else {
            bt.rxBufferFlush();
        }
    }
    bt.unlock();
}