#include "HC05.h"
#include <stdarg.h> 

HC05::HC05(PinName tx_pin, PinName rx_pin, PinName en_pin):
    MODSERIAL(tx_pin, rx_pin),
    on_switch(en_pin)
{
    //wait_ms(5000);  //mark
    on_switch = 0;
}
void HC05::start(){
    on_switch = 1;
}
int HC05::printfCRC ( const char * format, ... ){
         
    va_list argptr; /* Set up the variable argument list here */
    va_start(argptr, format);
    int ret = sprintf(buffer,format, argptr); 
    va_end(argptr);  /* Signify end of processing of variable arguments */   
    
    int i = 0;
    while(i < BUFFER_SIZE && buffer[i]){    
        putc(buffer[i]);
        i++;
    }    
    unsigned short checksum = calculateCRC16(buffer,i);

    //printf(" %d %d ", checksum >> 8, checksum & 0xFF);   

    for( int j = 0; j < 4; j++)        
        putc( ( checksum >> ( 4* (3-j) ) ) & 0x0F);
        
    //putc(checksum & 0xFF);
    putc('\r');
    putc('\n');

    return ret;
    }
    
void HC05::printBufferCRC(){
    int i = 0;
    while(i < BUFFER_SIZE && buffer[i]){    
        putc(buffer[i]);
        i++;
    }    
    unsigned short checksum = calculateCRC16(buffer,i);

    //printf(" %d %d ", checksum >> 8, checksum & 0xFF);   

    for( int j = 0; j < 4; j++)        
        putc( ( checksum >> ( 4* (3-j) ) ) & 0x0F);
        
    //putc(checksum & 0xFF);
    putc('\r');
    putc('\n');    
    }
//void HCO5::stop(){
//    on_switch = 0;
//}