#ifndef HC05_H
#define HC05_H

#include "mbed.h"
#include "rtos.h"
#include "MODSERIAL.h"
#include "CRC16.h"

#define BUFFER_SIZE  512

class HC05 : public MODSERIAL, public Mutex, public CRC16
{
private:
public:
    char buffer[BUFFER_SIZE];
    
    DigitalOut on_switch;
    
    HC05(PinName tx_pin, PinName rx_pin, PinName en_pin);
    int printfCRC( const char * format, ... );
    void printBufferCRC();
    void start();
    void stop();
 
};

#endif
