/*
main Program für Easyfit Projekt

*/

// Includes ____________________________________________________________________
#include <mbed.h>
#include <Ausgabe.h>
#include <memory.h>
#include <teach.h>
#include <kinematics.h>
#include <BNO055.h>
#include <training.h>
#include <Battery.h>
#include "stdio.h"
#include <sstream>
#include <string>


// Defines _____________________________________________________________________
#define SAMPLERATE 100
#define UBUNGSDAUER 4                                                          // repetitions neadet to teach exercice
#define HOLDTIME 1                                                             // time to stand still until standstil is recognised
#define POSITIONINGTIME 3                                                      // time to get into the start position
#define STARTDELAY 0.7                                                         // time from start signal to start of recording
#define ENTPRELLTIME 0.3
#define SINGLE 1                                                               // puls formats     
#define DOUBLE 10                                                              // puls formats 
#define TRIPPLE 12                                                             // puls formats 
//#define
#define STOP_PIN D3
#define PLAY_PIN D4
#define FORWARD_PIN D2

// Deklarationen _______________________________________________________________

// Debugging
DigitalOut myled(LED2);
Serial pc(SERIAL_TX,SERIAL_RX, 500000);

// Interrupts für Taser
InterruptIn  stopp(STOP_PIN,PullUp);
InterruptIn  play(PLAY_PIN,PullUp);
InterruptIn  forward(FORWARD_PIN,PullUp);

DigitalIn d_stop(STOP_PIN);
DigitalIn d_play(PLAY_PIN);
DigitalIn d_forward(FORWARD_PIN);

// Entprellen
Timeout entprell_timeout;
void entprell_enable();
volatile bool taster_enable;

// Tiker
Ticker imuEvent;
Ticker updateStatus;
// Variabeln Menuauswahl
//int display_enable;
int switch_menu;
int switch_ubung;
int enter_menu;
int enter_ubung;
int start_record;

// Variabeln IMU und Kinematics
bool imuGetsample;
bool updateStatusbar;
bool posGetsample;

//Variabeln Statusbalken
char statusbar[2];
char pre_statusbar[2];

// interrupt service routines
void forward_menu();
void enter();
void esc();



// Ticker service routines
void imuTriggered();
void updateBar();

// Klassen
Ausgabe display;
memory mem;
Kinematics kin(SAMPLERATE);
BNO055 bno;
teach tea;
training tra;
Battery bat;


// Funktionen __________________________________________________________________
void teach();
int pointindex = 0;
bool end = false, start = false, holdold = false, holdnew = true, save = false, sampeld = false;
int buff;
int repetitioncount = 0;
void training();
int pointindex2 = 0;
void training_end();

// Main ________________________________________________________________________
int main(void)
{

// Initalisation Menuauswahl
    display.enable =1;
    switch_menu  = 1;
    switch_ubung = 1;
    enter_menu = 0;
    enter_ubung = 0;
    start_record = 0;
    taster_enable = 1;

// Aufruf Taster Interrupts
    forward.fall(&forward_menu);
    play.fall(&enter);
    stopp.fall(&esc);

// Initalisation BNO055 und Kinematics
    imuGetsample = false;
    posGetsample = false;
    imuEvent.attach(&imuTriggered, 1.0/SAMPLERATE);
    updateStatus.attach(&updateBar, 1.0);
    bno.setup();


// reset statusbar
    statusbar[0] = 0;
    statusbar[1] = 0;
    int stat = 0;
    //const char bmp[] = "/sd/test.bmp";

    // main loop
    while(1) {
        display.setfreq(15000000);
        //display.statusbar(sta gyro, staBat);
        //wait(0.1); // Zyklszeit in sekunden


        // IMU Auslesen
        if(imuGetsample && enter_ubung) {
            imuGetsample = false;

            // read data from IMU
            bno.readQuat();
            kin.ori = bno.ori;

            bno.readLIA();
            kin.acc = bno.acc;

            kin.ori.makeRM();
            // transfer vector from lokal to global system
            kin.lacc = kin.transver_vector(kin.acc, kin.ori.rm);
            //filter
            kin.lacc = kin.filteracc(kin.lacc);
            //round value so you accually get 0
            kin.lacc = kin.accround(kin.lacc,0.1);
            //do math
            kin.updateAll(kin.lacc);    //integrate acceleration
            sampeld = true;
        }
        if(updateStatusbar) {
            updateStatusbar = false;
            // there has to be a better way...
            pre_statusbar[0] = statusbar[0]; //store previous state
            pre_statusbar[1] = statusbar[1];
            statusbar[0] = bno.readCALI() & 0x3f;  //get new state
            statusbar[1] = bat.read();
            if(pre_statusbar[0] != statusbar[0] || pre_statusbar[1] != statusbar[1]) {    //if states not equal -> update statusbar
                display.statusbar(statusbar[0],statusbar[1]);
            }
            //printf("%x\n",statusbar[1]);
            /*
            mkdir("/sd", 0777);
            stat = display.tft.DrawBitmapFile(0, 100, "/sd/golden_apple_24bit.bmp");
            printf("%i\n",stat);
            */
        }
        //printf("sw %i, su %i, em %i, eu %i, r %i\n",switch_menu,switch_ubung,enter_menu,enter_ubung,start_record);

        //resets submenu so you always start with first pos
        //uncomment if not cool
        if(enter_menu==0) {
            switch_ubung = 1;
        }

        switch(switch_menu) {

            case 1: // trainig =================================================

                // Menu Auswahl
                if(enter_menu) {


                    // Übungs Anwahl training
                    switch(switch_ubung) {

                        case 1: // trainig Übung 1 *********************************
                            if(enter_ubung) {

                                display.exercise("Uebung", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }
                            break;

                        case 2: // trainig Übung 2 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        case 3: // trainig Übung 3 *********************************
                            if(enter_ubung) {

                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }

                            }
                            break;

                        case 4: // trainig Übung 4 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        case 5: // trainig Übung 5 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        case 6: // trainig Übung 6 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        case 7: // trainig Übung 7 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                                
                            }

                            break;

                        case 8: // trainig Übung 8 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        case 9: // trainig Übung 9 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        case 10: // trainig Übung 10 *********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    training();
                                }
                                if(!start_record && save) {                                 // save trainings data
                                    training_end();
                                }
                            }

                            break;

                        default:
                            switch_ubung = 1;
                            break;
                    }

                    if(!enter_ubung) {
                        display.training(switch_ubung);
                    }

                }
                break;

            case 2: //  teach ==================================================

                // Menu Auswahl
                if(enter_menu) {



                    switch(switch_ubung) {

                        case 1: // teach Übung 1 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }
                            }
                            break;

                        case 2: // teach Übung 2 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 3: // teach Übung 3 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 4: // teach Übung 4 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 5: // teach Übung 5 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 6: // teach Übung 6 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 7: // teach Übung 7 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 8: // teach Übung 8 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 9: // teach Übung 9 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        case 10: // teach Übung 10 ***********************************
                            if(enter_ubung) {
                                display.exercise("Uebung ", switch_ubung);
                                if(start_record) {
                                    teach();
                                }

                            }
                            break;

                        default:
                            switch_ubung = 1;
                            break;
                    }
                    if(!enter_ubung) {
                        display.teach(switch_ubung);
                    }


                }
                break;


            case 3: //  history ================================================

                // Menu Auswahl
                if(enter_menu) {



                    switch(switch_ubung) {

                        case 1: // history Übung 1 *********************************
                            if(enter_ubung) {
                                printf("hystory Ubung %d \r\n", switch_ubung);
                                display.exercise_stat("Uebung 1");

                            }
                            break;

                        case 2: // history Übung 2 *********************************
                            if(enter_ubung) {
                                printf("history Ubung %d \r\n", switch_ubung);
                                display.exercise_stat("Uebung 2");
                            }
                            break;

                        case 3: // history Übung 3 *********************************
                            if(enter_ubung) {
                                printf("history Ubung %d \r\n", switch_ubung);
                                display.exercise_stat("Uebung 3");
                            }
                            break;

                        default:
                            switch_ubung = 1;
                            break;
                    }
                    if(!enter_ubung) {
                        display.history(switch_ubung);
                    }
                }
                break;

            default:
                switch_menu = 1;
                break;
        }
        if(!enter_menu) {
            display.mainmenu(switch_menu);
        }
    }
}

// Funktionen
void teach()
{   
    if((kin.getTime() % 10 == 0) && sampeld){
    sampeld = false;
    printf("in teach index: %d \n", pointindex);                               // debuging
    
    //wait(0.1);

    holdold = holdnew;                                                         // edge dedect
    holdnew = kin.acc_timeout(HOLDTIME, kin.lacc);


    if(!end && !start) {                                                       // set first point
        wait(POSITIONINGTIME);
        display.feedback(DOUBLE);
        printf("------------------------>in position \n");
        wait(STARTDELAY);
        kin.resetAll();
        tea.setstart(kin.pos.x, kin.pos.y, kin.pos.z, kin.getTime());
        end = true;
        start = false;
        pointindex++;
        holdold = !holdold;

    }
    buff++;                                                                    // compensating for to early endpoint

    /* if((~holdold & holdnew) && (end ==true) && (buff == true)) {
         buff = false;
         printf("buff");
         holdold = !holdold;

    }*/


    if((~holdold & holdnew) && (end ==true) && buff>3) {                                           // set endpoint
        tea.setend(kin.pos.x, kin.pos.y, kin.pos.z, kin.getTime());
        pointindex++;
        kin.vel.reset();
        kin.acc.reset();
        kin.lacc.reset();
        end = false;
        start = true;
        printf("---------------------------->endpoint \n");                               
        display.feedback(SINGLE);
        holdold = !holdold;

    }

    if((~holdold & holdnew) && (start == true)) {
        kin.resetAll();                                                        // set start point
        tea.setstart(kin.pos.x, kin.pos.y, kin.pos.z, kin.getTime());
        pointindex = 0;
        end = true;
        start = false;
        repetitioncount++;
        printf("------------------>startpoint \n");                               
        display.feedback(DOUBLE);
    }

    if((kin.getTime()/10) == pointindex) {                                        // set point, *10 für debuging
        tea.setpoint(kin.pos.x, kin.pos.y, kin.pos.z, kin.getTime());
        pointindex++;
    }

    // wen teach fertig abfragen ob save oder nicht
    // speichern
    if(repetitioncount == UBUNGSDAUER) {                                       // end of teach after enogh repetitions
        std::string integer;

        std::stringstream converter;                                           // combine teach numer to name for memory
        converter << switch_ubung;
        converter >> integer;
        std::string spacer = "Uebung " + integer;

        tea.save(spacer);
        end = false;
        start = false;
        buff = 0;
        repetitioncount = 0 ;
        enter_ubung = 0;
        tea.stop();
        display.feedback(TRIPPLE);
    }// nicht speichern
    // tea.stop()
    }
}

void training()
{   
                                                                            
    //wait(0.1);
    if((kin.getTime() % 10 == 0) && sampeld){
    sampeld = false;
    printf("in teach index: %d \n", pointindex); 
    int resetval = 0;
    if(pointindex2 == 0) {                                                     // initialisation and start of training by first cal
        save = true;
        std::string integer;
        
        std::stringstream converter;                                           // convert string to load training
        converter << switch_ubung;
        converter >> integer;
        std::string spacer = "Uebung " + integer;
        
        tra.load_training(spacer);
        tra.start_training();
        pointindex2++;
        wait(POSITIONINGTIME);
        printf("------------------>Start Training \n");
        display.feedback(DOUBLE);
        
    }

    resetval = tra.compire_point(kin.pos.x, kin.pos.y, kin.pos.z, kin.getTime());         // compairs points with loadat training
    pointindex++;
    
    if(resetval == 1) {                                                        // if startpoint reset IMU
        kin.resetAll();
        printf("------------------>startpoint reacht \n");
        pointindex = 0;
        
    }
    if(resetval == 2) {                                                        // if indpoint Reset IMU_Vellocity
        kin.vel.reset();
        printf("-------------------->Endpiont Reached \n");
    }

    if(resetval == 3) {                                                        // if a rong position is dedectet actifate fibration
        display.feedback(SINGLE);
        printf("------------------->Failed position \n");
    }
    }

}

void training_end()
{
    save = false;
    pointindex = 0;
    pointindex2 = 0;
    tra.end_training("Nutzerdaten");
    printf("saved Trainings Data");   
}

// Entprell
void entprell_enable()
{
    taster_enable = 1;
}


// interrupt service routines für Taster
void forward_menu()
{
    if(taster_enable) {
        taster_enable = 0;
        entprell_timeout.attach(&entprell_enable, ENTPRELLTIME);

        if(enter_menu) {
            switch_ubung++;
            enter_ubung = 0;
        } else {
            switch_menu++;
            enter_menu = 0;
        }
        display.enable = 1;
    }
}

void enter()
{

    if(taster_enable) {             // entprell
        taster_enable = 0;
        entprell_timeout.attach(&entprell_enable, ENTPRELLTIME);
        if(enter_ubung) {
            start_record = 1;
        }
        if(enter_menu) {
            enter_ubung = 1;
        } else {
            enter_menu = 1;
        }

        display.enable = 1;
    }
}

void esc()
{

    if(enter_menu == 0) {
        return;
    }
    if(taster_enable) {             // entprell
        taster_enable = 0;
        entprell_timeout.attach(&entprell_enable, ENTPRELLTIME);
        if(start_record) {
            start_record = 0;
        }
        if(enter_ubung) {
            enter_ubung = 0;
        } else {
            enter_menu = 0;
        }

        display.enable = 1;

    }
}
// Ticker service routine
void imuTriggered()
{
    imuGetsample = true;
}
void updateBar()
{
    updateStatusbar = true;
}