/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a1.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}


/* Simple main function */
int main() {
  uint8_t id;
  float value1, value2;
  char buffer1[32], buffer2[32];
  int32_t axes[3];
  int32_t m[3];
  int32_t n[3];
  int32_t r;
  int32_t i;
  int32_t lock_unlock=0;
  printf("\r\n--- Starting new run ---\r\n");

  humidity_sensor->ReadID(&id);
  printf("HTS221  humidity & temperature    = 0x%X\r\n", id);
  //pressure_sensor->ReadID(&id);
 // printf("LPS25H  pressure & temperature    = 0x%X\r\n", id);
  //magnetometer->ReadID(&id);
  //printf("LIS3MDL magnetometer              = 0x%X\r\n", id);
  gyroscope->ReadID(&id);
  printf("LSM6DS0 accelerometer & gyroscope = 0x%X\r\n", id);
  
  DigitalOut myled(LED1);
  DigitalIn mybutton(USER_BUTTON);
  
  wait(3);
 
  while(1) {
    wait(1);
    printf("\r\n");
    
    temp_sensor1->GetTemperature(&value1); 
    humidity_sensor->GetHumidity(&value2);
    if ((value1>27) && (value2>70))
        {
           myled=1;
           wait(1);
           myled=0;
           printf("Excessive Temperature & Excessive Humidity\r\n");
        }
    if ((value1>27) && (value2<=70))
        {
            myled=1;
            wait(0.3);
            myled=0;
            printf("Excessive Temperature\r\n");
        }
    if ((value1<=27) && (value2>70))
        {
            myled=1;
            wait(0.6);
            myled=0;
            printf("Excessive Humidity\r\n");
        }
    
    
    printf("HTS221: [temp] %7s°C,   [hum] %s%%\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
    temp_sensor2->GetFahrenheit(&value1);
    //pressure_sensor->GetPressure(&value2);
    //printf("LPS25H: [temp] %7s°F, [press] %smbar\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));

    if(mybutton == 0)
        {
            lock_unlock =! lock_unlock;
            myled=1;
            wait(0.2);
            myled=0;
            wait(0.2);
            myled=1;
            wait(0.2);
            myled=0;
            }
    
    if (lock_unlock == 0)
        {
        printf("SecuritySystemON\r\n");
        accelerometer->Get_X_Axes(axes);
        for (i=0;i<3;i++)
            {
                m[i]=axes[i];
            }
        wait(0.2);
        accelerometer->Get_X_Axes(axes);
        for (i=0;i<3;i++)
            {
                n[i]=axes[i];
            }
        r=(m[0]-n[0])*(m[0]-n[0])+(m[1]-n[1])*(m[1]-n[1])+(m[2]-n[2])*(m[2]-n[2]);
        if(r>70)
            {
                myled=1;
                printf("Security Alert\r\n");
            }
        printf("LSM6DS0 [acc/mg]:%6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    }
    if (lock_unlock != 0)
        {
            printf("UNLOCKED\r\n");
            printf("SecuritySystemOFF\r\n");
            }

    wait(1.5);
  }
}
