#include "mbed.h"
#include <map>
#include <string>

InterruptIn pound(p25);
InterruptIn ldr(p16);

DigitalOut myled(LED1);
DigitalOut dot(p20);
DigitalOut dash(p19);
DigitalOut buzz(p18);
DigitalOut newled(p15);

Timer t1;
Timer t2;
Timer t3;

std::map<std::string, char> asciiMap;

Serial pc(USBTX, USBRX);
std::string curStr;

int state = 0;
int spacestate =0;

void init(){
        asciiMap[".-"]='a';
        asciiMap["-..."]='b';
        asciiMap["-.-."]='c';
        asciiMap["-.."]='d';
        asciiMap["."]='e';
        asciiMap["..-."]='f';
        asciiMap["--."]='g';
        asciiMap["...."]='h';
        asciiMap[".."]='i';
        asciiMap[".---"]='j';
        asciiMap["-.-"]='k';
        asciiMap[".-.."]='l';
        asciiMap["--"]='m';
        asciiMap["-."]='n';
        asciiMap["---"]='o';
        asciiMap[".--."]='p';
        asciiMap["--.-"]='q';
        asciiMap[".-."]='r';
        asciiMap["..."]='s';
        asciiMap["-"]='t';
        asciiMap["..-"]='u';
        asciiMap["...-"]='v';
        asciiMap[".--"]='w';
        asciiMap["-..-"]='x';
        asciiMap["-.--"]='y';
        asciiMap["--.."]='z';
        asciiMap[".----"]='1';
        asciiMap["..---"]='2';
        asciiMap["...--"]='3';
        asciiMap["....-"]='4';
        asciiMap["....."]='5';
        asciiMap["-...."]='6';
        asciiMap["--..."]='7';
        asciiMap["---.."]='8';
        asciiMap["----."]='9';
        asciiMap["-----"]='0';
}

void ldrON() {
        t2.stop();
        
        t3.start();
        //pc.printf(" ldr on ");
        
    }

void ldrOFF() {
    t3.stop();
    buzz = 1;
    wait(t3.read());
    buzz = 0;
    if(t3.read_ms() > 30 && t3.read_ms() <= 200){
            dot = 0;
            //buzz =0;
            curStr = curStr + ".";
            //pc.printf(".");
        }
        else if (t3.read_ms() > 200) {
            //dash= 0;
            //buzz = 0;
            curStr = curStr + "-";
            //pc.printf("-");
        }
        wait(0.1);
        
    dot =1;
    
    t3.reset();
    t2.reset();
    
    t2.start();
    }

void pPress () {
        //t2.stop();
                   
        t1.start();
        myled = 1;
        newled = 0;
        //buzz = 1;
        
    }
void pRelease() {
        t1.stop();
        /*if(t1.read_ms() > 30 && t1.read_ms() <= 200){
            dot = 0;
            //buzz =0;
            curStr = curStr + ".";
            //pc.printf(".");
        }
        else if (t1.read_ms() > 200) {
            //dash= 0;
            //buzz = 0;
            curStr = curStr + "-";
            //pc.printf("-");
        }
        wait(0.1);
        */
        t1.reset();
        //t2.reset();
        state = 1;
        
        //dot = 1;
        //buzz = 0;
        //dash = 1;
        myled = 0;
        newled = 1;
        
        //t2.start();
    }
int main() {
    init();
    
    dot=1;
    dash=1;
    buzz = 0;
    myled = 0;
    newled = 1;
    
    pound.rise(&pPress);
    pound.fall(&pRelease);
    
    ldr.rise(&ldrON);
    ldr.fall(&ldrOFF);
    
    t2.start();
    while(1) {
        if(t3.read_ms()> 200) {
            dash = 0;
            //buzz = 0;
            wait(0.1);
            dash = 1;
            //buzz =1;
            }
        char c;
        if(t2.read_ms() > 400 && state ==1) {
            dot = 1;
            dash= 1;
            spacestate = 1;
            //buzz = 1;
            c = asciiMap[curStr];
            pc.printf("%c",c);
            curStr.clear();
            //pc.printf(" ");
            state =0;
            //pc.printf("%s",curStr);
        }
        if(spacestate == 1 && t2.read_ms() > 5000){
            pc.printf(" ");
            spacestate =0;
        }
    }
}