//Part 5
//The code below uses all previous parts of the lab to read
//in the appropriate dot/dash input from the user and record them
//and based on the input reference a table that maps the input
//to a specific alphanumeric character

#include "mbed.h"
#include <map>
#include <string>

//Initialize Inturrupt
InterruptIn pound(p25);
//Initialize Digatl I/O
DigitalOut myled(LED1);
DigitalOut dot(p20);
DigitalOut dash(p19);
//Initialize Timer
Timer t1;
Timer t2;
//Initialize Map
std::map<std::string, char> asciiMap;
//Serial Connection to view output
Serial pc(USBTX, USBRX);

//variables
std::string curStr;
int state = 0;

//Mores Code -> Character Map
void init(){
        asciiMap[".-"]='a';
        asciiMap["-..."]='b';
        asciiMap["-.-."]='c';
        asciiMap["-.."]='d';
        asciiMap["."]='e';
        asciiMap["..-."]='f';
        asciiMap["--."]='g';
        asciiMap["...."]='h';
        asciiMap[".."]='i';
        asciiMap[".---"]='j';
        asciiMap["-.-"]='k';
        asciiMap[".-.."]='l';
        asciiMap["--"]='m';
        asciiMap["-."]='n';
        asciiMap["---"]='o';
        asciiMap[".--."]='p';
        asciiMap["--.-"]='q';
        asciiMap[".-."]='r';
        asciiMap["..."]='s';
        asciiMap["-"]='t';
        asciiMap["..-"]='u';
        asciiMap["...-"]='v';
        asciiMap[".--"]='w';
        asciiMap["-..-"]='x';
        asciiMap["-.--"]='y';
        asciiMap["--.."]='z';
        asciiMap[".----"]='1';
        asciiMap["..---"]='2';
        asciiMap["...--"]='3';
        asciiMap["....-"]='4';
        asciiMap["....."]='5';
        asciiMap["-...."]='6';
        asciiMap["--..."]='7';
        asciiMap["---.."]='8';
        asciiMap["----."]='9';
        asciiMap["-----"]='0';
}

//Function when button pressed
void pPress () {
        t2.stop();
            //Space identification is moved to while loop    
        t1.start();
        myled = 1;        
    }
//Function when button is released
void pRelease() {
        t1.stop();     //stop dot dash timer
        if(t1.read_ms() > 30 && t1.read_ms() <= 200){
            dot = 0;
            curStr = curStr + ".";   //add dot to curstring
        }
        else if (t1.read_ms() > 200) {
            curStr = curStr + "-";   //add dash to curstring
        }
        
        wait(0.1);   //added for stability
        
        //Reset timers
        t1.reset();
        t2.reset();
        //state recognizes when there has been an input
        state = 1;
        //Clear Outputs
        dot = 1;
        dash = 1;
        myled = 0;
        //start space timer
        t2.start();
    }
int main() {
    //Initialize outputs
    init();
    dot=1;
    dash=1;
    myled = 0;
    //Initialize Inturrupts
    pound.rise(&pPress);
    pound.fall(&pRelease);
    t2.start();  //start space timer
    while(1) {
         //used to light dass based on input length
        if(t1.read_ms()> 200) {
            dash = 0;     
            wait(0.1);
            dash = 1;
            }
        //alphanumberic charact to be displayed
        char c;
        if(t2.read_ms() > 400 && state ==1) {
            //clear seven segment display
            dot = 1;       
            dash= 1;
            //map char based on string of dots and dashes
            c = asciiMap[curStr];
            pc.printf("%s : %c",curStr,c);  //print input and char
            curStr.clear();                 //clear input
            pc.printf(" ");                 //print space
            state =0;                       //clear input state
        }
    }
}