//Part 4
//This code is similar to part 3 but displays the dot
//or dash on a seven segment display. Again dot or 
//dash is determined by length of input by user

#include "mbed.h"

//Initialize Interrupt
InterruptIn pound(p25);
//Initialize Digital I/O
DigitalOut myled(LED1);
DigitalOut dot(p20);
DigitalOut dash(p19);
//Initialize Timers
Timer t1;
Timer t2;

//Serial Interface for Debugging 
Serial pc(USBTX, USBRX);

//Function to be called when button is pressed
void pPress () {
        t2.stop();            //stop space timer
        if(t2.read_ms() > 400)//if the length is greater than 400ms
         dot = 1;             //turn of dot
         dash= 1;             //turn of dash
         pc.printf(" ");      //space is added         
        t1.start();           //start dot/dash timer
        myled = 1;            //turn on led for debugging
    }
    
//Function to be called when button is released
void pRelease() {
        t1.stop();          //stop dot/dash timer
        if(t1.read_ms() > 30 && t1.read_ms() <= 200){
            dot = 0;        //turn on dot 
            pc.printf(".");
        }
        else if (t1.read_ms() > 200) {
            pc.printf("-");   //register dash don't turn on because already on
        }
        //delay for stability
        wait(0.1);
        
        //reset timers
        t1.reset();
        t2.reset();
        
        dot = 1;              //turn dot off
        dash = 1;             //turn dash off
        myled = 0;            //turn off led
        //start space timer
        t2.start();
    }
int main() {
    //Int State for LEDs
    dot=1;
    dash=1;
    myled = 0;
    //Initialize Inturrupt funct rise/fall edge
    pound.rise(&pPress);
    pound.fall(&pRelease);
    t2.start();     //start space timer
    while(1) {
        if(t1.read_ms()> 200) { //if this is true then button is depressed still 
            dash = 0;           //dash is registered
            wait(0.1);          //wait short duration for stability
            dash = 1;           //turn off then back on if still depressed
            }
    }
}