//Part 3
//This function is used to simply identify whether a specific
//input from a button is a dot or dash based on the length of
//time the button is pressed

#include "mbed.h"

//Initialize Interrupt
InterruptIn pound(p25);
//Initialize Digital Out
DigitalOut myled(LED1);
//Initialize Timers
Timer t1;
Timer t2;

//Serial Interface for Debugging
Serial pc(USBTX, USBRX);

//Function to be called when button is pressed
void pPress () {
        t2.stop();            //stop space timer
        if(t2.read_ms() > 400)//if the length is greater than 400ms
            pc.printf(" ");   //space if added         
        t1.start();           //start dot/dash timer
        myled = 1;            //turn on led for debugging
    }
    
//Function Called when button is released
void pRelease() {
        t1.stop();           //stop dot/dash timer
        if(t1.read_ms() > 30 && t1.read_ms() <= 200) 
            pc.printf(".");  //dot if length less than 200ms
        else if (t1.read_ms() > 200)
            pc.printf("-");  //dash if length greater than 200ms
        myled = 0;
        //reset both timers
        t1.reset();
        t2.reset();
        //start space timer
        t2.start();
    }
//mainfunction
int main() {
    myled = 0;
    //Initialize Interrupts for rising/falling edge
    pound.rise(&pPress);
    pound.fall(&pRelease);
    t2.start();
    while(1) {
    }
}