#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);

void pMesg(char * mesg, float temp)
{
            lcd.locate(0,3);
            lcd.printf("Temp = %.3f\n",temp);
            lcd.locate(0,15);
            lcd.printf("%s",mesg);
            wait(2);
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Temp = %.3f\n",temp);
}

int main ()
{

    float cur_temp, prev_temp;
    //Try to open the LM75B
    if (sensor.open()) {
        printf("Device detected!\n");
    
    lcd.cls();
    cur_temp = (float)sensor;
    prev_temp = cur_temp;
    pMesg("Normal",prev_temp);
    
        while (1) {
            cur_temp = (float)sensor;
            if(cur_temp >= prev_temp +2.0) {
                pMesg("Higher",cur_temp);
                prev_temp = cur_temp;
            } else if(cur_temp <= prev_temp - 2.0) {
                pMesg("Lower",cur_temp);
                prev_temp = cur_temp;
            }         
            wait(1.0);
        }

    } else {
        error("Device not detected!\n");
    }

}
