//Uses the measured z-acceleration to drive leds 2 and 3 of the mbed
 
#include "mbed.h"
#include "MMA7660.h"
 
MMA7660 MMA(p28, p27);
BusOut leds(LED1,LED2,LED3,LED4);

//used for debugging
Serial pc(USBTX, USBRX);
 
int main() {  
    if (MMA.testConnection())
        leds = 0x1;
        wait(1);
        leds = 0x0;
        float x = 0, y = 0, z = 0;
    while(1) {
        leds = 0x0;
        x = MMA.x();
        y = MMA.y();
        z = MMA.z();
        
//NOTE: All directions based on looking at device with MBED cord towards
//the user       
        if(x > 0.5){  //Forward
            leds = 0x6;
            wait(1);
        }
        if(x < -0.5){  //Backwards
            leds = 0x9;
            wait(1);
        }
         if(y > 0.5){  //LEFT
            leds = 0xE;
            wait(1);
        }
        if(y < -0.5){  //RIGHT
            leds = 0x7;
            wait(1);
        }
        if((z) > 1.2){  //UP
            leds = 0xF;
            wait(1);
        }
        if((z) < 0.5){  //DOWN
            leds = 0xA;
            wait(0.2);
            leds = 0x5;
            wait(0.2);
            leds = 0xA;
            wait(0.2);
            leds = 0x5;
            wait(0.2);
            leds = 0xA;
            wait(0.2);
            leds = 0x5;
            wait(0.2);
        }
        
        
        
        
        //for debug
        //pc.printf("x: %f  y: %f z: %f \r",MMA.x(),MMA.y(),MMA.z());
      
    }
 
}
