#include "mbed.h"
#include <map>
#include <string>

//Initialize serial comms
Serial pc(USBTX, USBRX);

PwmOut PWMh(p22);
//because both use same ticker make a new manual pmw
DigitalOut PWMl(p21);
Ticker PWMcont;
//PwmOut PWMl(p21);

DigitalOut row1(p26);
DigitalOut row2(p23);
DigitalOut row3(p24);
DigitalOut row4(p25);

DigitalIn col1(p20);
DigitalIn col2(p19);
DigitalIn col3(p18);
DigitalIn col4(p17);
Timer t1;

//map for keypad and DTMF
map<int, char> keypadMap;
map<int, char *> dtmfMap; 

//global on for PWMl (low freqency)
int on = 0;

//Map for keypad
//First 4 bits corrospond to active column
//Last 4 bits corrospond to active row

//DTMF
//Maps the current input to appropriate two
//frequencies
void init(){
        keypadMap[0x11]='1';
        keypadMap[0x12]='2';
        keypadMap[0x14]='3';
        keypadMap[0x18]='A';
        keypadMap[0x21]='4';
        keypadMap[0x22]='5';
        keypadMap[0x24]='6';
        keypadMap[0x28]='B';
        keypadMap[0x41]='7';
        keypadMap[0x42]='8';
        keypadMap[0x44]='9';
        keypadMap[0x48]='C';
        keypadMap[0x81]='*';
        keypadMap[0x82]='0';
        keypadMap[0x84]='#';
        keypadMap[0x88]='D';
        
        dtmfMap[0x11]="1029,697"; //1
        dtmfMap[0x12]="1336,697"; //2
        dtmfMap[0x14]="1477,697"; //3
        dtmfMap[0x18]="1633,697"; //A
        dtmfMap[0x21]="1209,770"; //4
        dtmfMap[0x22]="1336,770"; //5
        dtmfMap[0x24]="1477,770"; //6
        dtmfMap[0x28]="1633,770"; //B
        dtmfMap[0x41]="1209,852"; //7
        dtmfMap[0x42]="1336,852"; //8
        dtmfMap[0x44]="1477,852"; //9
        dtmfMap[0x48]="1633,852"; //C
        dtmfMap[0x81]="1209,941"; //*
        dtmfMap[0x82]="1336,941"; //0
        dtmfMap[0x84]="1477,941"; //#
        dtmfMap[0x88]="1633,941"; //D
}

//Flip function is attached to ticker to flip
//PWMl (low Frequency)
void flip() {
    if(on == 1)
        PWMl = !PWMl;
    else
        PWMl = 0;
}

int main() {
    init();
    //Initialize rows to 0
    row1 = 0;
    row2 = 0;
    row3 = 0;
    row4 = 0;
    PWMl = 0;
    t1.start();
    int cur_input = 0x00;
    int prev_input = 0x00;
    
    //main loop
    while(1) {
        
        
        //If there was no previous input than switch rows
        if(prev_input == 0){
            //make all rows 0 to add stability
            row1 = 0;
            row2 = 0;
            row3 = 0;
            row4 = 0;
           //Keep each pin on for 4ms
           //"turn on" appropriat bit in map when on.
           switch(t1.read_ms()%4){
                            case 0:
                            row1 = 1;
                            cur_input |= 0x10;   
                            break;
                            case 1:
                            row2 = 1;
                            cur_input |= 0x20;
                            break;
                            case 2:
                            row3 = 1;
                            cur_input |= 0x40;
                            break;
                            case 3:
                            row4 = 1; 
                            cur_input |= 0x80;
                            break; 
                            }
                }
            //Check each colum to see if it is high
            //if it is "turn on" that respective bit
             if(col1 == 1)
             cur_input |= 0x01;
             else if(col2 == 1)
             cur_input |= 0x02;
             else if(col3 == 1)
             cur_input |= 0x04;
             else if(col4 == 1)
             cur_input |= 0x08;
             else cur_input = 0;    //Detect button release or no input set input to 0
             
             //If curr input is non zero continue
             if(cur_input) {
                if(cur_input != prev_input) {
                    char c = keypadMap[cur_input]; //assign charcter based on input
                    if(c != 0){
                        pc.printf("%c\r",c);  //print input and char
                    }
                    //Assign freql and freqh based on current input
                    float freqh,freql;
                    char *freq = dtmfMap[cur_input];
                    sscanf(freq,"%f,%f",&freqh,&freql);
                    pc.printf("High:%f, Low:%f\r",freqh,freql);
                    //Set the low frequency on ticker
                    on = 1;
                    // the address of the function to be attached (flip) and the interval (1/freql)
                    PWMcont.attach(&flip, (1/(2*freql))); 
                    //Set the high frequency on PWMout 
                    PWMh.period(1/freqh);             // set PWM period to user specified for high tone
                    PWMh=0.5;                         // set duty cycle to 50%    
                }
            }
            //Turn off pulse width modulation if curr input is 0
            else {
                PWMh = 0.0;
                on = 0;
             } 
       
     //Maintain the past input
     prev_input = cur_input;
     

    }
  
}