#include "mbed.h"
#include <map>

//Initialize serial comms
Serial pc(USBTX, USBRX);

//Initialize PMW
PwmOut PWM1(p21);


//Initialize Keypad I/O
DigitalOut row1(p26);
DigitalOut row2(p23);
DigitalOut row3(p24);
DigitalOut row4(p25);

DigitalIn col1(p20);
DigitalIn col2(p19);
DigitalIn col3(p18);
DigitalIn col4(p17);
Timer t1;

//map used for keypad
map<int, char> keypadMap;


//Map for keypad
//First 4 bits corrospond to active column
//Last 4 bits corrospond to active row
void init(){
        keypadMap[0x11]='1';
        keypadMap[0x12]='2';
        keypadMap[0x14]='3';
        keypadMap[0x18]='A';
        keypadMap[0x21]='4';
        keypadMap[0x22]='5';
        keypadMap[0x24]='6';
        keypadMap[0x28]='B';
        keypadMap[0x41]='7';
        keypadMap[0x42]='8';
        keypadMap[0x44]='9';
        keypadMap[0x48]='C';
        keypadMap[0x81]='*';
        keypadMap[0x82]='0';
        keypadMap[0x84]='#';
        keypadMap[0x88]='D';
}

int main() {
    init();
    //Initialize rows to 0
    row1 = 0;
    row2 = 0;
    row3 = 0;
    row4 = 0;
    t1.start();
    int input = 0x00;
    while(1) {
        //make all rows 0 to add stability
        row1 = 0;
        row2 = 0;
        row3 = 0;
        row4 = 0;
       //Keep each led lit for 4ms
       switch(t1.read_ms()%4){
                        case 0: row1 = 1;
                                input |= 0x10;   
                                break;
                        case 1: row2 = 1;
                                input |= 0x20;
                                break;
                        case 2: row3 = 1;
                                input |= 0x40;
                                break;
                        case 3: row4 = 1; 
                                input |= 0x80;
                                break; }
         //Pull the value from each column and check to see if 1
         if(col1 == 1)
            input |= 0x01;
         else if(col2 == 1)
            input |= 0x02;
         else if(col3 == 1)
            input |= 0x04;
         else if(col4 == 1)
            input |= 0x08;
         
         char c = keypadMap[input]; //assign charcter based on input
         //Print to the terminal the character if available 
         if(c != 0){
            pc.printf("%c\r",c);  //print input and char
         }
         //reset input
         input = 0x00;     
    }
}
