#include "mbed.h"

//Initialize PWM
PwmOut PWM1(p21);
Serial pc(USBTX, USBRX);
Timer t1;


//Initialize Input buffer
char input[10];

  
 int main()
{
    //define input variables
    float freq;
    int dur;
    //Check if input is valid
    int isint;
    while(1){
            //wait for a valid input
            while(isint != 2) {
                //Input Desired Tone
                printf("Input Desired Tone: Frequency (Hz) Duration (ms) followed by enter\r");
                char c = pc.getc();
                int i =0;
                
                //wait for return to be pressed
                while(c != '\r') {
                        printf("%c",c);  //echo
                        input[i++]=c;    //add current char to buffer
                        c = pc.getc();
                    }
                    input[i] = '\0';    //end buffer
                isint = sscanf(input, "%f %d",&freq,&dur);      //assign input variables
                //printf("isint = %d\r",isint); //debug check if input is correct
                //if input is incorrect this will be displayed
                if(isint!= 2)
                printf("You did not enter a number.Please enter an argument's number\r");
            }
          //wait for another enter to output the tone
          if(pc.readable()) {
              //if enter is pressed continue to output tone
              if(pc.getc() == '\r')
             {
                //show user what value was input
                printf("Valid Input Frequency = %3.0f, Duration  = %d\r", freq, dur);
                isint = 0;  //reset input
                
                //Play tone with correct freq and durration
                //Timer used for duration
                t1.reset();
                t1.start();
                PWM1.period(1/freq);               // set PWM period to user specified   
                PWM1=0.5;                         // set duty cycle to 50% 
                while(t1.read_ms() < dur){
                    //WAIT
                    }
                PWM1=0.0;                         //turn off
                t1.stop();    
             }
            //if another button is pressed besides enter abort and start over
             else{
                printf("You didn't press enter\r");
                isint = 0;  
                 }
            }    
      }
      
}