#include "mbed.h"
#include <map>
#include <string>

InterruptIn pound(p25);
DigitalOut myled(LED1);
DigitalOut dot(p20);
DigitalOut dash(p19);
DigitalOut buzz(p18);

Timer t1;
Timer t2;

std::map<std::string, char> asciiMap;

Serial pc(USBTX, USBRX);
std::string curStr;

int state = 0;

void init(){
        asciiMap[".-"]='a';
        asciiMap["-..."]='b';
        asciiMap["-.-."]='c';
        asciiMap["-.."]='d';
        asciiMap["."]='e';
        asciiMap["..-."]='f';
        asciiMap["--."]='g';
        asciiMap["...."]='h';
        asciiMap[".."]='i';
        asciiMap[".---"]='j';
        asciiMap["-.-"]='k';
        asciiMap[".-.."]='l';
        asciiMap["--"]='m';
        asciiMap["-."]='n';
        asciiMap["---"]='o';
        asciiMap[".--."]='p';
        asciiMap["--.-"]='q';
        asciiMap[".-."]='r';
        asciiMap["..."]='s';
        asciiMap["-"]='t';
        asciiMap["..-"]='u';
        asciiMap["...-"]='v';
        asciiMap[".--"]='w';
        asciiMap["-..-"]='x';
        asciiMap["-.--"]='y';
        asciiMap["--.."]='z';
        asciiMap[".----"]='1';
        asciiMap["..---"]='2';
        asciiMap["...--"]='3';
        asciiMap["....-"]='4';
        asciiMap["....."]='5';
        asciiMap["-...."]='6';
        asciiMap["--..."]='7';
        asciiMap["---.."]='8';
        asciiMap["----."]='9';
        asciiMap["-----"]='0';
}

void pPress () {
        t2.stop();
                   
        t1.start();
        myled = 1;
        buzz = 0;
        
    }
void pRelease() {
        t1.stop();
        if(t1.read_ms() > 30 && t1.read_ms() <= 200){
            dot = 0;
            buzz =0;
            curStr = curStr + ".";
            //pc.printf(".");
        }
        else if (t1.read_ms() > 200) {
            //dash= 0;
            //buzz = 0;
            curStr = curStr + "-";
            //pc.printf("-");
        }
        wait(0.1);
        t1.reset();
        t2.reset();
        state = 1;
        
        dot = 1;
        buzz = 1;
        //dash = 1;
        myled = 0;
        
        t2.start();
    }
int main() {
    init();
    dot=1;
    dash=1;
    buzz = 1;
    myled = 0;
    pound.rise(&pPress);
    pound.fall(&pRelease);
    t2.start();
    while(1) {
        if(t1.read_ms()> 200) {
            dash = 0;
            buzz = 0;
            wait(0.1);
            dash = 1;
            buzz =1;
            }
        char c;
        if(t2.read_ms() > 400 && state ==1) {
            dot = 1;
            dash= 1;
            buzz = 1;
            c = asciiMap[curStr];
            pc.printf("%s : %c",curStr,c);
            curStr.clear();
            pc.printf(" ");
            state =0;
            //pc.printf("%s",curStr);
        }
    }
}