#include "mbed.h"
#include "rtos.h"
#include "mbed_rpc.h"
#include "string.h"
#define _MBED_
#include "Adafruit_9DOF.h"
#include "Serial_base.h"
 
Serial pc(USBTX, USBRX); // tx, rx
Serial bluetooth(p9, p10);  // tx, rx
Ticker compassTicker;
float compassValue;
float *ax, *ay, *az, *mx, *my, *mz;

DigitalOut led1(LED1), led2(LED2), led3(LED3);
 
//Use the RPC enabled wrapped class  - see RpcClasses.h for more info
RpcDigitalOut leftTop(p20,"leftTop");
RpcDigitalOut leftBottom(p12,"leftBottom");
RpcDigitalOut rightTop(p22,"rightTop");
RpcDigitalOut rightBottom(p29,"rightBottom");
 
char buf[256], outbuf[256];

bool compassTriggered = false;
bool bluetoothTriggered = false;




/* Assign a unique ID to the sensors */

Adafruit_9DOF                 dof   = Adafruit_9DOF();
Adafruit_LSM303_Accel_Unified accel = Adafruit_LSM303_Accel_Unified(30301);
Adafruit_LSM303_Mag_Unified   mag   = Adafruit_LSM303_Mag_Unified(30302);
/* Update this with the correct SLP for accurate altitude measurements */
float seaLevelPressure = SENSORS_PRESSURE_SEALEVELHPA;
/**************************************************************************
    @brief  Initialises all the sensors used by this example
**************************************************************************/

void initSensors(){
  if(!accel.begin()){
   /* There was a problem detecting the LSM303 ... check your connections */
    s_com->println(("Ooops, no LSM303 detected ... Check your wiring!"));
    while(1);
  }
  
  if(!mag.begin()){
    /* There was a problem detecting the LSM303 ... check your connections */
    s_com->println("Ooops, no LSM303 detected ... Check your wiring!");
    while(1);
  }
}

void setup(void){
    s_com->println(("Adafruit 9 DOF Pitch/Roll/Heading Example"));
    s_com->println("");
    
    /* Initialise the sensors */
    initSensors();
}




 
void compassTickerCallback() {
    compassTriggered = true;
}

void bluetoothCallback() {
    bluetoothTriggered = true;
}



void compassTickerHandler() {
    led1 = 1;

    sensors_event_t accel_event;
    sensors_event_t mag_event;
    sensors_vec_t   orientation;

    /* Calculate pitch and roll from the raw accelerometer data */
    accel.getEvent(&accel_event);
    if (dof.accelGetOrientation(&accel_event, &orientation)){
        /* 'orientation' should have valid .roll and .pitch fields */
        s_com->print(("Roll: "));
        s_com->print(orientation.roll);
        s_com->print(("; "));
        s_com->print(("Pitch: "));
        s_com->print(orientation.pitch);
        s_com->print(("; "));
    }

    /* Calculate the heading using the magnetometer */
    mag.getEvent(&mag_event);
    if (dof.magGetOrientation(SENSOR_AXIS_Z, &mag_event, &orientation)){
        /* 'orientation' should have valid .heading data now */
        s_com->print(("Heading: "));
        s_com->print(orientation.heading);
        s_com->print(("; "));
    }
    
    s_com->println((""));

    led1 = 0;
    compassTriggered =  false;
}

void bluetoothHandler() {
    bluetooth.gets(buf, 256);
    //pc.puts(buf);
    //Call the static call method on the RPC class
    RPC::call(buf, outbuf); 
    //bluetooth.printf("%s\n", outbuf);
    bluetoothTriggered = false;
}


int main() {
    
    pc.baud(115200);
    bluetooth.baud(115200);
    
    setup();
    compassTicker.attach(&compassTickerCallback, 5); // the address of the function to be attached (flip) and the interval (2 seconds)
    
    while(1) {
        if(pc.readable()) {
            pc.putc(pc.getc());
        }
        if(bluetooth.readable()) {
            bluetooth.gets(buf, 256);
            RPC::call(buf, outbuf); 
        }
        if(compassTriggered){
            compassTickerHandler();
        }


    }
}