#include "mbed.h"
 
Serial pc(USBTX, USBRX); 
AnalogIn lightSensor(p17);
Ticker reader;
Timer t;
DigitalOut buzzerOut(p21);

bool flag = false;
int timeElapsed = 0;
uint16_t analogValue;
 
void readAnalogValue(){
    analogValue = lightSensor.read_u16();
}
 
int main() {
    pc.baud(9600);
    reader.attach(&readAnalogValue, 0.001);
    while(1) {
        //pc.printf("Analog value: %d \n \r", analogValue);
        //pc.printf(flag?"true":"false");
        if(flag){
            flag = false;
            if(timeElapsed > 30 && timeElapsed < 200) {
                buzzerOut = 1;
                wait_ms(100);
                buzzerOut = 0;
                pc.printf("Dot \r \n");
            }
            else if(timeElapsed >= 200) {
                buzzerOut = 1;
                wait_ms(200);
                buzzerOut = 0;
                pc.printf("Dash \r \n");
            }   
            timeElapsed = 0;      
        }
    
        if(analogValue > 8000){
            if(t.read_ms() != 0){}
            else
                t.start(); 
        }
        if(analogValue <= 8000){
            if(t.read_ms() != 0){
                t.stop();
                
                timeElapsed = t.read_ms();
                t.reset();    
            }
            flag = true;
        }
    }
}