#include "mbed.h"
#include <iostream>

Serial pc(p9,p10);

Serial gps(p28, p27);

DigitalIn button(p21);

void getline();

char gpsmsg[256];

int main()
{
    while(1) {

        // Flush output buffer
        char char1;
        while (pc.readable()) {
            char1 = pc.getc();
        }
        
        char nodeid[4] = "190";
        float altitude;

        char startkey[12] = "SentinelOn";
        char endkey[13] = "SentinelOff";
        char buffer[30];
        char ns, ew;
        int lock;
        int satsused;
        float hdop;
        float latitude, longitude;
        
        float time;

        gps.baud(4800);

        do {
            if (pc.readable() == true) {
                // Get bytes from computer
                pc.scanf("%s",buffer);
            }
        } while (strcmp( startkey, buffer ) != 0);

        // Flush output buffer
        while (pc.readable()) {
            char1 = pc.getc();
        }

        pc.printf("Sentinel Is On\n");


        while(1) {
            getline();
            if(sscanf(gpsmsg, "GPGGA,%f,%f,%c,%f,%c,%i,%i,%f,%f", &time, &latitude, &ns, &longitude, &ew, &lock, &satsused, &hdop, &altitude) >= 1) {
                if((lock != 1) && (lock != 2) && (lock != 6)) {
                    pc.printf("DNLK,%s,NOLOCK\n",nodeid, latitude, longitude, altitude);
                } else {
                    double degrees;
                    double minutes = modf(latitude/100.0f, &degrees);
                    minutes = (minutes*100.0f)/60.0f;
                    latitude = degrees + minutes;
                    
                    minutes = modf(longitude/100.0f, &degrees);
                    minutes = (minutes*100.0f)/60.0f;
                    longitude = degrees + minutes;
                    
                    if(ns == 'S') {
                        latitude  *= -1.0;
                    }
                    if(ew == 'W') {
                        longitude *= -1.0;
                    }
                    pc.printf("DLIN,%s,%f,%f,%f\n",nodeid, latitude, longitude, altitude);
                }
            }
            if (pc.readable() == true) {
                pc.scanf("%s",buffer);
                if (strcmp( endkey, buffer ) != 0) {
                    break;
                }
            }
        }
    }
}

void getline()
{
    while(gps.getc() != '$');    // wait for the start of a line
    for(int i=0; i<256; i++) {
        gpsmsg[i] = gps.getc();
        if(gpsmsg[i] == '\r') {
            gpsmsg[i] = 0;
            return ;
        }
    }
    error("Overflowed message limit");
}