#ifndef HEAD_H
#define HEAD_H

#include "mbed.h"
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "math.h"
#include "rtos.h"
#include <string>

#define YELLOW              0xFFFF00
#define ORANGE              0xffdd76
#define MECYAN              0x009696

AnalogIn timer(p20);
Mutex stdio_mutex;
uLCD_4DGL lcd(p28, p27, p30);

AnalogIn steer(p17);
AnalogIn force(p16);

volatile int count=30;
volatile int a=0;
volatile int cheat=3;

void start()
{
    lcd.baudrate(300000);
    lcd.printf("Need for Speed  :P  \n");
    lcd.printf("------------------");
    lcd.printf("1. Rotation Sensor - To steer right or left\n\n");
    lcd.printf("2. Force Sensor - To speed up\n\n");
    lcd.printf("3. Touch Sensor - To Cheat (3 times max)\n\n\n");
    lcd.printf("  Touch to begin!\n");
}

void forward(void const *args)
{
    while(1) {
        stdio_mutex.lock();
        if (timer<0.1) {
            if(count<29 && cheat>0) {
                ++count;
                ++count;
                --cheat;
            }
            if(timer<0.1 && cheat<1) {
                lcd.printf("STOP cheating");
            }
        }
        stdio_mutex.unlock();
        Thread::wait(400);
    }
}

void steering(void const *args)
{
    while(1) {
        stdio_mutex.lock();
        lcd.cls();
        a=floor(steer*39);
        if(a>9) {
            a=9;
        }
        switch(a) {
            case (1): {
                lcd.filled_rectangle(0, 98, 9, 110, BLUE);
                break;
            }
            case (2): {
                lcd.filled_rectangle(14, 98, 23, 110, BLUE);
                break;
            }
            case (3): {
                lcd.filled_rectangle(28, 98, 37, 110, BLUE);
                break;
            }
            case (4): {
                lcd.filled_rectangle(42, 98, 51, 110, BLUE);
                break;
            }
            case (5): {
                lcd.filled_rectangle(56, 98, 65, 110, BLUE);
                break;
            }
            case (6): {
                lcd.filled_rectangle(70, 98, 79, 110, BLUE);
                break;
            }
            case (7): {
                lcd.filled_rectangle(84, 98, 93, 110, BLUE);
                //Thread::wait(200);
                break;
            }
            case (8): {
                lcd.filled_rectangle(98, 98, 107, 110, BLUE);
                //  Thread::wait(200);
                break;
            }
            case (9): {
                lcd.filled_rectangle(112, 98, 121, 110, BLUE);
                //  Thread::wait(200);
                break;
            }
        }
        Thread::wait(200);
        stdio_mutex.unlock();

    }
}

void obstacle(void const *args)
{
    while(1) {
        stdio_mutex.lock();
        switch(count) {
            case (30): {
                lcd.filled_rectangle(0, 0, 90, 10, RED);
                break;
            }
            case (29): {
                lcd.filled_rectangle(0, 10, 90, 20, RED);
                break;
            }
            case (28): {
                lcd.filled_rectangle(0, 20, 90, 30, RED);
                break;
            }
            case (27): {
                lcd.filled_rectangle(0, 30, 90, 40, RED);
                break;
            }
            case (26): {
                lcd.filled_rectangle(0, 40, 90, 50, RED);
                break;
            }
            case (25): {
                lcd.filled_rectangle(0, 50, 90, 60, RED);
                lcd.filled_rectangle(70, 0, 90, 10, GREEN);
                break;
            }
            case (24): {
                lcd.filled_rectangle(0, 60, 90, 70, RED);
                lcd.filled_rectangle(70, 10, 127, 20, GREEN);
                break;
            }
            case (23): {
                lcd.filled_rectangle(0, 70, 90, 80, RED);
                lcd.filled_rectangle(70, 20, 127, 30, GREEN);
                break;
            }
            case (22): {
                lcd.filled_rectangle(0, 80, 90, 90, RED);
                lcd.filled_rectangle(70, 30, 127, 40, GREEN);
                break;
            }
            case (21): {
                lcd.filled_rectangle(0, 90, 90, 100, RED);
                lcd.filled_rectangle(70, 40, 127, 50, GREEN);
                break;
            }
            case (20): {
                lcd.filled_rectangle(0, 100, 90, 110, RED);
                lcd.filled_rectangle(70, 50, 127, 60, GREEN);
                if(a<8) {
                    lcd.locate(3,8);
                    lcd.printf("YOU LOSE!!!");
                    exit(0);
                }
                break;
            }
            case (19): {
                lcd.filled_rectangle(0, 110, 100, 120, RED);
                lcd.filled_rectangle(70, 60, 127, 70, GREEN);
                lcd.filled_rectangle(40,0 , 90,10 , WHITE);
                break;
            }
            case (18): {
                lcd.filled_rectangle(0, 120, 100, 130, RED);
                lcd.filled_rectangle(70, 70, 127, 80, GREEN);
                lcd.filled_rectangle(40,10 , 90,20 , WHITE);
                break;
            }
            case (17): {
                lcd.filled_rectangle(70, 80, 127, 90, GREEN);
                lcd.filled_rectangle(40,20 , 90, 30, WHITE);
                break;
            }
            case (16): {
                lcd.filled_rectangle(70, 90, 127, 100, GREEN);
                lcd.filled_rectangle(40,30 , 90, 40, WHITE);
                break;
            }
            case (15): {
                lcd.filled_rectangle(70, 100, 127, 110, GREEN);
                lcd.filled_rectangle(40,40 , 90,50 , WHITE);
                if(a>6) {
                    lcd.locate(3,8);
                    lcd.printf("YOU LOSE!!!");
                    exit(0);
                }
                break;
            }
            case (14): {
                lcd.filled_rectangle(70, 110, 127, 120, GREEN);
                lcd.filled_rectangle(40,50 , 90, 60, WHITE);
                break;
            }
            case (13): {
                lcd.filled_rectangle(70, 120, 127, 130, GREEN);
                lcd.filled_rectangle(40, 60 , 90, 70, WHITE);
                lcd.filled_rectangle(0, 0 , 30, 10, YELLOW);
                lcd.filled_rectangle(60, 0 , 127, 10, YELLOW);
                break;
            }
            case (12): {
                lcd.filled_rectangle(40, 70, 90, 80 , WHITE);
                lcd.filled_rectangle(0, 10, 30, 20, YELLOW);
                lcd.filled_rectangle(60, 10, 127, 20, YELLOW);
                break;
            }
            case (11): {
                lcd.filled_rectangle(40, 80, 90, 90 , WHITE);
                lcd.filled_rectangle(0, 20 , 30, 30, YELLOW);
                lcd.filled_rectangle(60, 20 , 127, 30, YELLOW);
                break;
            }
            case (10): {
                lcd.filled_rectangle(40, 90, 90, 100 , WHITE);
                lcd.filled_rectangle(0, 30 , 30, 40, YELLOW);
                lcd.filled_rectangle(60, 30 , 127, 40, YELLOW);
                break;
            }
            case (9): {
                lcd.filled_rectangle(40,100 , 90, 110, WHITE);
                lcd.filled_rectangle(0, 40 , 30, 50, YELLOW);
                lcd.filled_rectangle(60, 40 , 127, 50, YELLOW);
                if(a>3 && a<8 ) {
                    lcd.locate(3,8);
                    lcd.printf("YOU LOSE!!!");
                    exit(0);
                }
                break;
            }
            case (8): {
                lcd.filled_rectangle(40,110 , 90, 120, WHITE);
                lcd.filled_rectangle(0, 50 , 30, 60, YELLOW);
                lcd.filled_rectangle(60, 50 , 127, 60, YELLOW);
                break;
            }
            case (7): {
                lcd.filled_rectangle(40,120 , 90, 130, WHITE);
                lcd.filled_rectangle(0, 60 , 30, 70, YELLOW);
                lcd.filled_rectangle(60, 60 , 127, 70, YELLOW);
                break;
            }
            case (6): {
                lcd.filled_rectangle(0, 70 , 30, 80, YELLOW);
                lcd.filled_rectangle(60, 70 , 127, 80, YELLOW);
                break;
            }
            case (5): {
                lcd.filled_rectangle(0, 80 , 30, 90, YELLOW);
                lcd.filled_rectangle(60, 80 , 127, 90, YELLOW);
                break;
            }
            case (4): {
                lcd.filled_rectangle(0, 90 , 30, 100, YELLOW);
                lcd.filled_rectangle(60, 90 , 127, 100, YELLOW);
                break;
            }
            case (3): {
                lcd.filled_rectangle(0, 100 , 30, 110, YELLOW);
                lcd.filled_rectangle(60, 100 , 127, 110, YELLOW);
                if(a<4 || a>5 ) {
                    lcd.locate(3,8);
                    lcd.printf("YOU LOSE!!!");
                    exit(0);
                }
                break;
            }
            case (2): {
                lcd.filled_rectangle(0, 110 , 30, 120, YELLOW);
                lcd.filled_rectangle(60, 110 , 127, 120, YELLOW);
                break;
            }
            case (1): {
                lcd.filled_rectangle(0, 120 , 30, 130, YELLOW);
                lcd.filled_rectangle(60, 120 , 127, 130, YELLOW);
                break;
            }

        }
        stdio_mutex.unlock();
    }
}

#endif