/**
 ******************************************************************************
 * @file    main.cpp
 * @author  CLab
 * @version V1.0.0
 * @date    2-December-2016
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A1 
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/ 

/* Includes */
#include "mbed.h"
#include "XNucleoIKS01A2.h"
#include "MadgwickAHRS.h"
#define sampleFreqDef   10.0f

Serial pc(USBTX, USBRX, 115200);
uint8_t id;
float value1, value2;
char buffer1[32], buffer2[32];
char* nmea;
int32_t axes[3];
int32_t mag[3];
int32_t gyr[3];
int32_t ac[3];
float gyrf[3];
float pitch, roll, yaw;
uint32_t counter = 0;
int32_t mag_max[3];
int32_t mag_min[3]; // zmienne do przechwoywania "offsetu" magnetometru
bool initialized = false;

//enable a ticker that allows to  setup a recurring interrupt to repeatedly call a function at a specified rate.
Ticker flipper; 

Madgwick madgwick_filter;

/* Instantiate the expansion board */
static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);

/* Retrieve the composing elements of the expansion board */
static LSM303AGRMagSensor *magnetometer = mems_expansion_board->magnetometer;
static HTS221Sensor *hum_temp = mems_expansion_board->ht_sensor;
static LPS22HBSensor *press_temp = mems_expansion_board->pt_sensor;
static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;
static LSM303AGRAccSensor *accelerometer = mems_expansion_board->accelerometer;

/* Helper function for printing floats & doubles */
static char *print_double(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if (fractPart >= i) {
      break;
    }
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}


// NMEA conversion
void float_to_char(float my_float, char* tab){
    tab[0] = (char)( (int)(my_float/100.0) + 48);
    tab[1] = (char)( (int)((my_float - (tab[0]- '0')*100)/10.0) + 48);
    tab[2] = (char)( (int)((my_float - (tab[0]- '0')*100 - (tab[1]- '0')*10 )) + 48);
    tab[4] = (char)( (int)((my_float - (tab[0]- '0')*100 - (tab[1]- '0')*10  - (tab[2]- '0'))*10.0) + 48);
    tab[5] = (char)( (int)((my_float - (tab[0]- '0')*100 - (tab[1]- '0')*10 -  (tab[2]- '0') - (tab[4]- '0')/10.0)*100.0) + 48);
}

char * get_nmea_sentence(float roll, float pitch, float yaw){
    static char sentence[] = "$PASHR,hhmmss.sss,hhh.hh,T,rrr.rr,ppp.pp,xxx.xx,a.aaa,b.bbb,c.ccc,d,e*hh\n\r\n";
    //float roll_deg =    roll *  360/(2*3.14);
   // float pitch_deg =   pitch * 360/(2*3.14);
   // float yaw_deg =     yaw *  360/(2*3.14);

    float_to_char(roll, sentence + 27);
    float_to_char(pitch, sentence + 34);
    float_to_char(yaw, sentence + 18);

    return sentence;
}


void update_filter(){
    magnetometer->get_m_axes(axes);
    mag[0] = axes[0] + 15;
    mag[1] = axes[1] + 180;
    mag[2] = axes[2] + 51;
    
    /* 
    if(initialized == false){
        mag_max[0] = mag[0];
        mag_max[1] = mag[1];
        mag_max[2] = mag[2];
        mag_min[0] = mag[0];
        mag_min[1] = mag[1];
        mag_min[2] = mag[2];
        initialized = true;
    }
    
      
    for(int i=0; i<3; i++){
        if(mag[i] > mag_max[i]){
            mag_max[i] = mag[i];
            }
        if(mag[i] < mag_min[i]){
            mag_min[i] = mag[i];
            }
        }
    */
        
    
    //pc.printf("LSM303AGR maximum axes values [mag/mgauss]:  %6ld, %6ld, %6ld\r\n", mag_max[0], mag_max[1], mag_max[2]);
    //pc.printf("LSM303AGR minimum axes values [mag/mgauss]:  %6ld, %6ld, %6ld\r\n", mag_min[0], mag_min[1], mag_min[2]);
    
    //pc.printf("mag1 is at 0x%08X\r\n", &mag[0]); it's how to get an adress for use in stm studio
  
    accelerometer->get_x_axes(axes);
    ac[0] = axes[0];
    ac[1] = axes[1];
    ac[2] = axes[2];
 //   printf("LSM303AGR [acc/g]:  %6ld, %6ld, %6ld\r\n", ac[0], ac[1], ac[2]);
    
   //acc_gyro->get_x_axes(axes);
   //printf("LSM6DSL [acc/mg]:      %6ld, %6ld, %6ld\r\n", ac[0], ac[1], ac[2]);    
    
    acc_gyro->get_g_axes(axes);
    gyr[0] = axes[0];
    gyr[1] = axes[1];
    gyr[2] = axes[2];
  //  printf("LSM6DSL [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", gyr[0], gyr[1], gyr[2]);
    
    gyrf[0] = 1.0*gyr[0];
    gyrf[1] = 1.0*gyr[1];
    gyrf[2] = 1.0*gyr[2];
   // printf(" gx: %.2f gy: %.2f , gz: %.2f\n\r", gyrf[0], gyrf[1], gyrf[2]);
    
    madgwick_filter.update((float)gyr[0]/1000.0, (float)gyr[1]/1000.0, (float)gyr[2]/1000.0, (float)ac[0], (float)ac[1], (float)ac[2], (float)mag[0], (float)mag[1], (float)mag[2]);
    //madgwick_filter.update(0,100,0,0,0,0,0,0,0);
    madgwick_filter.computeAngles();
    
    pitch = madgwick_filter.getPitch();
    roll = madgwick_filter.getRoll();
    yaw = madgwick_filter.getYaw();
}


int main() {
  
  /* Enable all sensors */
  hum_temp->enable();
  press_temp->enable();
  magnetometer->enable();
  accelerometer->enable();
  acc_gyro->enable_x();
  acc_gyro->enable_g();
  

  magnetometer->read_id(&id);
 // printf("LSM303AGR magnetometer            = 0x%X\r\n", id);
  accelerometer->read_id(&id);
 // printf("LSM303AGR accelerometer           = 0x%X\r\n", id);
  acc_gyro->read_id(&id);
 // printf("LSM6DSL accelerometer & gyroscope = 0x%X\r\n", id);
    
flipper.attach(&update_filter, 0.1);
    
    while(1){      
    //nmea = get_nmea_sentence(roll,pitch,yaw);
    //pc.printf("%s",nmea);
    pc.printf("no elo");
    wait_ms(500);
    }
}

