#include "mbed.h"
#include "QEI.h"

QEI myEncoder (p16,p15, NC, 1600); 
Timer t;
LocalFileSystem local("local");
Serial pc(USBTX, USBRX); 
  

int main ()
{
    printf("Running"); 
    int counter = 0;
    float time[500]={0} ; 
    float theta[500]={0} ; 
    int pulses = 0; 
    int k = 0; 
    
    wait (1);
    t.start();
    while (time[counter]<5.05)
    {
        wait(0.01); 
        pulses = myEncoder.getPulses(); 
        theta[counter] = ((float)pulses/ (1600.0*2.0))*2.0*3.14;
        time[counter] = t.read(); 
        //printf("Time(%d)= %f       Angle(%d) = %f \n", counter+1,time[counter],counter+1, theta[counter]);
        counter= counter + 1; 
    }
    t.stop();
    printf("Printing log variables to file on mBed           ... ");
    
    FILE *fp = fopen("/local/TURRET.M", "w");

    if(1) 
    {
        for(k=0; k<501; k++) 
        {
            fprintf(fp,"time(%d,1) = %.5f;\n",k+1,time[k]);
            fprintf(fp,"theta(%d,1) = %.5f;\n",k+1,theta[k]);  
            printf("In the loop");          
        }        
    }
    fclose(fp); 
    printf("Done printing\n"); 
}