#include "mbed.h"
#include "QEI.h"

PwmOut turret_speed(p21);
DigitalOut turret_direction(p22);

QEI myEncoder (p16,p15, NC, 1600); 
Timer t;

int main()
{
int input_dc =50; 
int user_direction = 0;
float duty_cycle = 0.0; 
int pulses = 0; 
float time[500]={0} ; 
float theta[500]={0} ; 
float ang_v[500]={0};
int counter = 1; 
int k = 0; 
 

while(1)
    {
    printf("Enter duty cycle, 0 to 100:\n"); 
    scanf("%d", &input_dc); 
    
    duty_cycle = input_dc/100.0;  
    
    printf("\n %f duty cycle set. Enter 0 for CCW or 1 for CW spin direction:\n",duty_cycle); 
    scanf("%d", &user_direction); 
   
    turret_speed = duty_cycle; 
    turret_direction = user_direction; 
    printf("%f duty cycle. %d spin.\n", duty_cycle, user_direction); 
  
    t.start();
    while(time[counter-1]<5.05)
       {
        wait(0.01); 
        pulses = myEncoder.getPulses(); 
        theta[counter] = ((float)pulses/ (1600.0*2.0))*-2.0*3.14;
        time[counter] = t.read();
        ang_v[counter]=(theta[counter]-theta[counter-1])/(time[counter]-time[counter-1]);      
       
        printf("time(%d,1) = %.5f;\n",counter,time[counter]);
        printf("theta(%d,1) = %.5f;\n",counter,theta[counter]); 
        printf("ang_v(%d,1) = %.5f; \n",counter,ang_v[counter]); 
        counter = counter +1; 
        }  
    turret_speed = 0; 
    t.stop();    
    
    for(k=0; k<counter+1; k++) 
        {
            printf("time(%d,1) = %.5f;\n",k+1,time[k]);
            printf("theta(%d,1) = %.5f;\n",k+1,theta[k]);           
        }    
    printf("Duty_Cycle = %f", duty_cycle); 
    
    }
}