#include "mbed.h"
// APIs
Serial pc(USBTX, USBRX); // tx, rx for serial USB interface to pc
SPI spi_max1270(p5, p6, p7);
SPI spi(p5, p6, p7);
DigitalOut max1270_cs(p8);  //MAX1270 ADC CS
DigitalOut mot1_ph1(p21);
//DigitalOut mot1_ph2(p22);
PwmOut mot_en1(p23);

LocalFileSystem local("local"); // Create the local filesystem under the name "local"

int read_max1270(int chan, int range, int bipol){
    int cword=0x80;     //set the start bit
    
    spi_max1270.frequency(10000000);
    spi_max1270.format(8, 0);   // 8 data bits, CPOL0, and CPHA0 (datasheet Digital Interface)
        
    cword |= (chan << 4);   //shift channel
    cword |= (range << 3);
    cword |= (bipol << 2);
            
    max1270_cs = 0;
           
    spi_max1270.write(cword);
    wait_us(15);    //15us
    spi_max1270.format(12, 3);
    
    int result = spi_max1270.write(0);
    
    max1270_cs = 1;
    spi_max1270.format(8, 0);
    return result;
}

float read_max1270_volts(int chan, int range, int bipol){
    float rangevolts=0.0;
    float volts=0.0;
    int adc_res;

    //read the ADC converter
    adc_res = read_max1270(chan, range, bipol) & 0xFFF;
        
   //Determine the voltage range
   if(range)  //RNG bit 
     rangevolts=10.0;
   else
     rangevolts=5.0;
             
   //bi-polar input range
   if(bipol){ //BIP is set, input is +/-
     if(adc_res < 0x800){ //if result was positive
      volts = ((float)adc_res/0x7FF) * rangevolts;      
     }       
     else{  //result was negative
      volts = -(-((float)adc_res/0x7FF) * rangevolts) - (rangevolts * 2.0); 
     }
   }
   else{  //input is positive polarity only
      volts = ((float)adc_res/0xFFF) * rangevolts;   
   }
   
   return volts;     
}

float Tank1,Tank2,dt,h1,h2;
float Ts = 1.0; // Sampling period 1/Ts Hz

// Calibration constant: change for your system
float v10 = 0;// V
float v20 = 0; //V
float c1 = 1; // cm/V
float c2 = 1;// cm/V

int leng = 200; 
// Arrays for data storage
float etime[200];
float t1v[200];
float t2v[200];
float t1h[200];
float t2h[200];
float dcp[200];

// Controller parameters
float r = 4;
float k1;
float k2;
float kcal;
float dcc;
float k1i;
float k2i;
float ki;
float w;
float wp;
float h1ss;
float h2ss;
float dc_op;
int full;
int CalOrInt;
Timer t;

 // Open "results.M" on the local file system for writing
FILE *fp = fopen("/local/data.M","w");

float cntr;
float dc;
int k;

int main ()
{
    pc.baud(921600); // Establish baud rate 
    mot_en1.period_us(50); // Set PWM length to 50 us   
    max1270_cs = 1; // Activate A/D
    cntr = 0.0; // cntr used to keep track of sample period and elpased time
    full = 1;
    wp = 0;
       
    // Operating point: change for your system
    h1ss = 10;
    h2ss = 10;
    dc_op = 0.7;
       
    // Set calibration or integral control
    //CalOrInt = 1; // calibration
    CalOrInt = 0; // integral control
    
    // Regualtor plus calibration design: change for your system
    k1 = 0;
    k2 = 0;
    kcal = 0;
    
    // Regualtor plus integral design: change for your system
    k1i = 0;
    k2i = 0;
    ki = 0;
    
    // initialize data vectors
    for(k=0;k<leng;k++)
  { etime[k] = 0.0;
    t1v[k] = 0.0;
    t2v[k] = 0.0;
    t1h[k] = 0.0;
    t2h[k] = 0.0;
    dcp[k] = 0.0;    
  }
  k = 0; // Reset index counter
    pc.printf(" Time Tank1  Tank2 H1    H2     DC  Full \n\r");        
    while(cntr*Ts <= leng) {
        t.start(); // start measuring comp time
        
        // Read pressure sensors        
        Tank1 = read_max1270_volts(1, 1, 1);
        Tank2 = read_max1270_volts(0, 1, 1);
        
        // Convert pressure voltage to tank height
        h1 = c1*(Tank1 - v10);
        h2 = c2*(Tank2 - v20);
        
        if ((h1 < 5)&(full==1)) {
                full  = 0;}
                
                
        if (h1 < 25.0) 
        {          
            if ((full==1)&(cntr*Ts <= leng)) 
                {
                 w = wp + (r-(h2-h2ss))*Ts; // integral of tracking error   
                // Compute deviation from operating duty cycle 
                if (CalOrInt == 1)    // Regulator plus calibration       
                    {dcc = kcal*r-(k1*(h1-h1ss)+k2*(h2-h2ss));}
                else if (CalOrInt == 0) // Regulator plus integral    
                    {dcc = ki*w-(k1i*(h1-h1ss)+k2i*(h2-h2ss));}
                // Update duty cycle
                dc = -dc_op-dcc;
                // age intgeral of tracking error variable
                wp = w;
                }
           
            else {dc = -dc_op;}            
        } 
        else {dc = 0.0;}   
        
        if(dc > 0.0)
            {
            mot1_ph1 = 1;
            mot_en1 = dc;
            }
        else if(dc < -0.0)
            {
            mot1_ph1 = 0;
            mot_en1 = abs(dc);
            }

        // Log data
        etime[k] = cntr*Ts;
        t1v[k] = Tank1;
        t2v[k] = Tank2;
        t1h[k] = h1;
        t2h[k] = h2;
        dcp[k] = -dc;
        k++;
              
        t.stop(); // end measuring comp time
        dt = Ts-t.read();
        pc.printf("%5.2f %5.2f %5.2f %5.2f %5.2f %5.2f %d \n\r",cntr*Ts,Tank1,Tank2,h1,h2,dc, full);        
        t.reset();
        cntr=cntr+1;
        wait(dt); // wait to ensure sampling period set by Ts    
    }//while
    
    // keep pump on between runs
    
    dc = -dc_op;
    if(dc > 0.0){
          mot1_ph1 = 1;
          mot_en1 = dc;
        }
    else if(dc < -0.0){
          mot1_ph1 = 0;
          mot_en1 = abs(dc);}
    
    //mot_en1 = 0.0; //shuts off pump
    
    // Print out log variables in MATLAB structured variable format.
    pc.printf("Printing log variables to file on mBed           ... ");
    if(1) {
        for(k=0; k<leng; k++) {
            fprintf(fp,"t(%d,1) = %.5f;\n",k+1,etime[k]);
            fprintf(fp,"t1v(%d,1) = %.5f;\n",k+1,t1v[k]);
            fprintf(fp,"t2v(%d,1)    = %.5f;\n",k+1,t2v[k]);
            fprintf(fp,"t1h(%d,1)    = %.5f;\n",k+1,t1h[k]);
            fprintf(fp,"t2h(%d,1)    = %.5f;\n",k+1,t2h[k]);
            fprintf(fp,"dcp(%d,1)    = %.5f;\n",k+1,dcp[k]);            
        }        
    }
    printf("done.\r\n");

    // Close file
    fclose(fp);
    
}//main
