#include "mbed.h"
#include "QEI.h"

PwmOut turret_speed(p21);
DigitalOut turret_direction(p22);

QEI myEncoder (p16,p15, NC, 1600); 
Timer t;

int main()
{
int input_dc =50; 
int user_direction = 0;
float duty_cycle = 0.0; 
int pulses = 0; 
float theta = 0.0;  
float time =0.0;
float signed_duty_cycle = 0.0; 
float Kp = 1;  

float theta_ref = 3.14/4.0; 

while(1)
    {
    //printf("Enter duty cycle, 0 to 100:\n"); 
    //scanf("%d", &input_dc); 
    
    //signed_duty_cycle = Kp*(theta_ref - theta); 
    //duty_cycle = input_dc/100.0;  
    duty_cycle = signed_duty_cycle/100.0; 
    
    printf("\n %f duty cycle set. Enter 1 for CCW or 0 for CW spin direction:\n",duty_cycle); 
    scanf("%d", &user_direction); 
    
    printf("it's starting... move the thing!\n");
    t.start();
    turret_speed = duty_cycle; 
    turret_direction = user_direction; 
    printf("%f duty cycle. %d spin.\n", duty_cycle, user_direction); 
    
    while(1)
        {
            wait(0.01); 
            pulses = myEncoder.getPulses(); 
            theta = ((float)pulses/ (1600.0*2.0))*-2.0*3.14;
            time = t.read(); 
            
            signed_duty_cycle = Kp*(theta_ref - theta); 
            duty_cycle = signed_duty_cycle; 
            turret_speed = duty_cycle; 
                        
            printf("time = %.5f;\n",time);
            printf("theta = %.5f;\n",theta); 
            printf("duty cyle= %f. \n", duty_cycle); 
        }      
    }
}