#include "mbed.h"
#include "TCS3472_I2C.h"

PwmOut LB(p25); // PWM out signal to power LED on the sensor
TCS3472_I2C rgb_sensor( p9, p10 ); // Establish RGB sensor object
Serial pc(USBTX,USBRX); // Establish serial connection with computer
DigitalOut led1(LED1); //Red
DigitalOut led2(LED2); //Green
DigitalOut led3(LED3); //Blue

int main()
{
    rgb_sensor.enablePowerAndRGBC(); // Enable RGB sensor
    rgb_sensor.setIntegrationTime(100); // Set integration time of sensor

    pc.baud(921600); // Set Baud rate of serial connection
    int rgb_data[4]; // declare a 4 element array to store RGB sensor readings
    float PWMbrightness = 1.0; // float specifying brightness of LED (between 0.0 and 1.0)

    while(1) {

        LB = PWMbrightness; // set brightness of sensor LED
        rgb_sensor.getAllColors( rgb_data ); // read the sensor to get red, green, and blue color data along with overall brightness

       // Print data to serial port
        pc.printf( "unfiltered: %d, red: %d, green: %d, blue: %d \n", rgb_data[0], rgb_data[1], rgb_data[2], rgb_data[3]); 
        wait(0.1);
        if((rgb_data[1] > 1600)&&(rgb_data[1] <2100)){
            led1 = 1;
            }
        else{
            led1 = 0; }
        if((rgb_data[2] > 1600)&&(rgb_data[2] < 3500)) {
            led2 = 1;
            }
        else{
            led2 = 0; }
        if((rgb_data[3] > 750)&&(rgb_data[3] < 1200)){
            led3 = 1;
            }
        else{
            led3 = 0; }
        if(rgb_data[0] > 4000){
            led1 = 0;
            led2 = 0;
            led3 = 0;}
    }// end while
}// end main
