#include "mbed.h"
#define ID 0x300
Ticker ticker1;
Ticker ticker2;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
CAN can(p30, p29); //CAN du mbed shield
char counter = 0;
char tabVal[10][8];
int index=0;

 
AnalogIn bouton(p15); // pin 15 pour ADC0 
 
void send() {
    CANMessage msgS;
    msgS.id=ID;
    msgS.len=1;
    if (counter == 0) { //On envoie des '0' et des '1'
        counter=1;
        }
    else {
        counter=0;
        }
    msgS.data[0]=counter;  
    if(can.write(msgS)){
        led3 = counter;// On allume la led3 quand on envoie
        //printf("Message sent: %d\n", counter);// On affiche
        }
}

void reader(void){
    CANMessage msgR;
    can.read(msgR);
    
    switch(msgR.id){
        
        case 0x100 :
            led1 = msgR.data[0];
            //printf("Message received: id= 0x%x _ data= %d _ len = %d type= %d _ format= %d \n",msgR.id,msgR.data[0],msgR.len,msgR.type,msgR.format); 
            printf("ID 0x100 = ");
            for(index=7;index>=0; index--)
                {
                tabVal[1][index]=msgR.data[index];
                printf("%d",msgR.data[index]);           
                }
            printf("\n");
            break;
            
        case 0x200 :
            led2 = msgR.data[0];
            //printf("Message received: id= 0x%x _ data= %d _ len = %d type= %d _ format= %d \n",msgR.id,msgR.data[0],msgR.len,msgR.type,msgR.format); 
            printf("ID 0x200 = ");
            for(index=7;index>=0; index--)
                {
                tabVal[2][index]=msgR.data[index];
                printf("%d",msgR.data[index]);         
                }
            printf("\n");
            break;      
        }     
}



int main() {
    can.frequency(125000);
    printf("main()\n");
    ticker1.attach(&send, 0.2);
    ticker2.attach(&reader, 0.1);
    wait(0.2);
}
    
