//Université Paris-Saclay - IUT de Cachan
//SNE S2 Prime   GR DP nov 2020
//***********************************************//
#include "mbed.h"
#include "C12832.h"
C12832 lcd(D11, D13, D12, D7, D10);
Ticker horloge_automate;
//
DigitalIn BPC (D4) ;  // bouton centre
DigitalOut LG (D9) ;  // led verte
DigitalOut LR (D5) ;  // led rouge

// prototype et variables globales et constantes
void automate(void);
int horloge_automate_flag=0;

void horloge_automate_isr(void)
{
    horloge_automate_flag=1;
}
//
int main()
{
    horloge_automate.attach(&horloge_automate_isr,0.1);
    lcd.cls();          
    lcd.locate(0,3);    
    lcd.printf("Automate");
    while(1) {
        if(horloge_automate_flag) {
            automate();
            horloge_automate_flag=0;
        }
    }
}
void automate(void)
{
    // définition d'un type énuméré permettant de manipuler l'état de l'automate
    // par son nom
    typedef enum {etat0=0, etat1=1, etat2=2} type_etat;
    type_etat etat_actuel = etat0 ;   // déclaration état actuel init. à etat0
    static type_etat etat_futur = etat0;  // déclaration état futur
    int entree;
    // gestion des entrees
    entree = BPC;  // c'est le bouton centre
    // gestion du diagramme de transition
    etat_actuel = etat_futur;   // mise à jour de l'état
    // calul de l'éat futur en fonction de l'état actuel et des entrées
    switch(etat_actuel) {
        case etat0 :
            if (entree) etat_futur = etat1;
            break;
        case etat1 :
            etat_futur = etat2;
            break;
        case etat2 :
            etat_futur = etat0;
            break;
    }
    // valeurs des  sorties en fonction de l'état actuel
    switch(etat_actuel) {
        case etat0 :
            lcd.locate(0,12);
            lcd.printf("Etat 0");
            LG=1;
            LR=1;
            break;
        case etat1 :
            lcd.locate(0,12);
            lcd.printf("Etat 1");
            LG=0;
            LR=1;
            break;
        case etat2 :
            lcd.locate(0,12);
            lcd.printf("Etat 2");
            LG=1;
            LR=0;
            break;
    }
}