//#include "mbed.h"  // car defini dans l'include suivant
#include "ihm_L476.h"
#define PI 3.14f
Serial pc(SERIAL_TX, SERIAL_RX);
CircularBuffer <unsigned char,1024> buf;
IHM_L476 ihm;
Timer temps;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
void serial_receive()
{
    unsigned char  c=pc.getc(); // attention à protéger les appels pc
    buf.push(c);
}
//
int main()
{
    char l1,l2;
    pc.baud(9600);
    //pc.printf("Hello World !\n");
    pc.attach(&serial_receive);     // isr sur reception char
    temps.reset();
    temps.start();
    int i = 0;
    float f=10;
    int j=0;
    char str[20];
    while(1) {
        // envoi de données
        int x=temps.read_ms();
        if((x>100)) {
            pc.printf("%f %f %d\r\n", sin(2*PI*i/f),cos(2*PI*i/f),x);
            i++;
            temps.reset();
        }
        //reception de données
        while(!buf.empty()) {
            unsigned char c;
            buf.pop(c);
            switch(c) {
                case '\r' :  // fin de message on traite
                    str[j]=NULL;  // fin de chaine
                    j=0;
                    // debut traitement chaine recue
                    sscanf(str,"%d %d %f",&l1,&l2,&f);
                    led1=l1;
                    led2=l2;
                    ihm.LCD_printf("%6.2f",f);
                    // fin traitement chaine recue
                    break;
                case '\n':  // on ignore
                    break;
                default :   // on stocke
                    str[j]=c;
                    j++;
            }
        }
    }
}