#include "mbed.h"
#include "GYRO_DISCO_L476VG.h"
#include "COMPASS_DISCO_L476VG.h"
//
#define TE 0.01
GYRO_DISCO_L476VG gyro;
COMPASS_DISCO_L476VG compass;
Serial pc(SERIAL_TX, SERIAL_RX,115200);
Ticker ticker;
DigitalOut led1(LED1);
volatile bool flag=0;
double psig=0,psia;
double gyro_zero(void)
{
    const int NN=10000;
    float GyroBuffer[3];
    double gy_off=0;
    for(int i=0; i<NN; i++) {
        gyro.GetXYZ(GyroBuffer);
        gy_off=gy_off+GyroBuffer[1]/NN;
    }
    return(gy_off);
}
double angle_zero(void)
{
    const int NN=1000;
    int16_t AccBuffer[3];
    double PI=4*atan(1.0);
    double ang_off=0;
    for(int i=0; i<NN; i++) {
        compass.AccGetXYZ(AccBuffer);
        double ang=(180/PI)*atan2((double)AccBuffer[0],(double)AccBuffer[2]);
        ang_off=ang_off+ang/NN;
    }
    return ang_off;
}
void mesure(void)
{
    flag=1;
}
int main()
{
    float GyroBuffer[3];
    int16_t AccBuffer[3];
    printf("Super inclinometre\n\r");
    double PI=4*atan(1.0);
    double gyr_off=gyro_zero();
    double ang_off=angle_zero();
    ticker.attach(&mesure,TE);
    unsigned char cpt=0;
    
    while(1) {
        if(flag) {
            compass.AccGetXYZ(AccBuffer);
            psia=((180.0/PI)*atan2((double)AccBuffer[0],(double)AccBuffer[2]))-ang_off;
            gyro.GetXYZ(GyroBuffer);
            psig=psig+(GyroBuffer[1]-gyr_off)*TE/1000;
            if(cpt==9) {
                cpt=0;
                led1 = !led1;
                pc.printf("$%f %f;\n",psia,psig);
            }
            cpt++;
            flag=0;
        }
    }
}
