/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 *    The application works with the BLEController iOS/Android App.
 *    Type something from the Terminal to send
 *    to the BLEController App or vice verse.
 *    Characteristics received from App will print on Terminal.
 */
 
#include "mbed.h"
#include "ble/BLE.h"
#include <string.h>

// TX POWER用
#include "ble_gap.h"
#define TX_POWER                         -8
//機器設定
//#define TX_ZERO                         
#define TX_POWER_CALI                    -10
//const static char     DEVICE_NAME[]        = "nRF51DK"; // change this

//#define TX_POWER_CALI                      -7
//const static char     DEVICE_NAME[]        = "51822"; // change this

//#define TX_POWER_CALI                    -15
//const static char     DEVICE_NAME[]        = "Nano"; // change this

//#define TX_POWER_CALI                      -12
const static char     DEVICE_NAME[]        = "MN8"; // change this


#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20

BLE  ble;

//ピン機能
Serial pc(USBTX, USBRX);
Ticker steper;
DigitalOut ledori1(LED1);
DigitalOut ledori2(LED2);
//DigitalOut USSTrigger(P0_25); // nRF51: P0_25 :超音波センサ　トリガ出力
DigitalOut USSTrigger(P0_20); // 51822: P0_25 :超音波センサ　トリガ出力
Timer ActiveTime;

//割り込み処理宣言
Ticker TriggerTiming; //Triggerピン :インターバルタイマ
//
InterruptIn USSEcho(P0_28); //nRF51 P0_28 :超音波センサ　エコー入力
InterruptIn USSEcho(P0_22); //51822 P0_28 :超音波センサ　エコー入力

//関数宣言
void initSonic(void);
void Output_Monitor(unsigned short Value);

//グローバル変数宣言
unsigned short USSDistance; //USSDistance :超音波センサの測定距離

// 60msごとの割り込みでUSSTriggerに10usのON出力
void Trigger() {
    USSTrigger = 1;
    wait_us(10);
    USSTrigger = 0;
}

//USSEcho立ち上がりでの割り込み
//Hiの場合ActiveTimeタイマスタート
void RiseEcho() {
    ActiveTime.start();
}

//USSEcho立ち下がりでの割り込み
//Lowの場合ActiveTime停止＋値読み取り
void FallEcho() {
    unsigned long ActiveWidth;
    ActiveTime.stop();
    ActiveWidth = ActiveTime.read_us();
    USSDistance = ActiveWidth * 0.0170;
    ActiveTime.reset();
}

void initSonic(void) {
    TriggerTiming.attach(Trigger, 0.060); //USSTrigger周期60ms
    USSEcho.rise(RiseEcho); //USSEcho立ち上がり時割り込み
    USSEcho.fall(FallEcho); //USSEcho立ち下がり時割り込み
}

void Output_Monitor(unsigned short Value){
    pc.printf("%d[cm]\r\n",Value);
}


// The Nordic UART Service
//static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
//static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
//static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
//static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

// Send One CLK Service
//static const uint8_t uart_base_uuid[] = {0x53, 0xF3, 0xF5, 0x38, 0x8D, 0x11, 0x48, 0x02, 0xB6, 0xFC, 0xFB, 0x66, 0x16, 0xD4, 0xCD, 0x7C}; //Service
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_送信用
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_受信用
//static const uint8_t uart_base_uuid_rev[] = {0x7C, 0xCD, 0xD4, 0x16, 0x66, 0xFB, 0xFC, 0xB6, 0x02, 0x48, 0x11, 0x8D, 0x38, 0xF5, 0xF3, 0x53};
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};


// TX POWER用
static const uint8_t power_level_uuid[]   = {0x71, 0x3D, 0, 4, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用
uint8_t powerPayload[TXRX_BUF_LEN] = {0,};
static uint8_t power_buf[TXRX_BUF_LEN];
static uint8_t power_len=0;
GattCharacteristic  txPowerCharacteristic (power_level_uuid, powerPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ); //tx power characteristic
Ticker txSteper;


// MSC UUID
static const uint8_t msc_uuid[]   = {0x71, 0x3D, 0, 6, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用
uint8_t mscPayload[TXRX_BUF_LEN] = {0,};
static uint8_t msc_buf[TXRX_BUF_LEN];
static uint8_t msc_len=0;
GattCharacteristic  mscCharacteristic (msc_uuid, mscPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ); //tx power characteristic


//Feature UUID
static const uint8_t feature_uuid[]   = {0x71, 0x3D, 0, 5, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用
uint8_t featurePayload[TXRX_BUF_LEN] = {0,};
static uint8_t feature_buf[TXRX_BUF_LEN];
static uint8_t feature_len=0;
GattCharacteristic  featureCharacteristic (feature_uuid, featurePayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ); //tx power characteristic


uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

static uint8_t rx_buf[TXRX_BUF_LEN];
static uint8_t rx_len=0;
static uint8_t rx_buf_st[20];

int8_t buf_before[40];

static int st = 0;


GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
                                      
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic, &txPowerCharacteristic, &mscCharacteristic, &featureCharacteristic};
GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));


// MSC UUID
void initMsc() {
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    //MSCのUUIDをセット
    sprintf(bufbuf_c, "%s", "00000008");
    //sprintf(bufbuf_c, "%d", "02f3f538-8d11-4802-b6fc-fb6616d4cd70");
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(mscCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
}


// Feature
void initFeature() {
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%s", "In.Sensor.USonic");
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(featureCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
}



// TX POWER用
void txPowerUpdate(int newTxPower) {
    sd_ble_gap_tx_power_set(newTxPower);
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%d",  newTxPower + TX_POWER_CALI);
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(txPowerCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
}

void txStep() {
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%d",  TX_POWER + TX_POWER_CALI);
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(txPowerCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
}


void initChara() {
    initMsc();
    initFeature();
    txStep();
}
//-------------------

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}


void onScanCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    //printf("onScanNau\n");
  
//    printf("adv peerAddr[%d %d %d %d %d %d] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",

//だいじ
/* 
    printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
    printf("\n");
    printf("Len:%d\n",params->advertisingDataLen);
    printf("Data:");
  for (int i=0; i< params->advertisingDataLen; i++){
    printf("%02x,",params->advertisingData[i]);
  }
  */
  
 // for (int i=0; i<params->advertisingDataLen; i++){
 //   printf("%02x,",params->advertisingData[i]);
 // }
  
    printf("\n");
    
//   DEBUG(" \n\r");
//#endif
    
    
}


void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead, index;
    
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) 
    {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);
        pc.printf("WriteHandler \r\n");
        pc.printf("Length: ");
        pc.putc(bytesRead);
        pc.printf("\r\n");
        pc.printf("Data: ");
        for(index=0; index<bytesRead; index++)
        {
            pc.putc(txPayload[index]);
        }
        pc.printf("\r\n");
    }
}

void uartCB(void)
{   
    while(pc.readable())    
    {
        rx_buf[rx_len++] = pc.getc();
        if(rx_len>=20 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n')
        {
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
            pc.printf("RecHandler \r\n");
            pc.printf("Length: ");
            pc.putc(rx_len);
            pc.printf("\r\n");
            rx_len = 0;
            break;
        }
    }
}


// 1++していく
void step() {
    //++st;
    //float pir = pirInAna;
    //pc.printf("%f", pir);


    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%d", USSDistance);
    
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    
//    ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
    ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
    
    pc.printf("%d", st);
    pc.printf("step! \r\n");
}


int main(void)
{
    ledori1 = 0;
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
   
    pc.baud(9600);
    pc.printf("SimpleChat Init \r\n");
    
    pc.attach( uartCB , pc.RxIrq);
   // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME) - 1);                                    
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(160);

    ble.addService(uartService);
    
    ble.setScanParams(GapScanningParams::SCAN_INTERVAL_MIN,
                      GapScanningParams::SCAN_WINDOW_MIN,
                      0);

    ble.startScan(&onScanCallback);
    
    ble.startAdvertising(); 
    pc.printf("Advertising Start \r\n");
    
    steper.attach(&step, 1.0);

    //TX POWER用
    txPowerUpdate(TX_POWER);
    //txSteper.attach(&initChara, 1.0);
    
    initChara();
    char val;
    initSonic();
    
    while(1)
    {
        ble.waitForEvent();
        //if( pc.readable() ){
          //  Output_Monitor( USSDistance );
            //val = pc.getc();
        //}
    }
}


