/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 *    The application works with the BLEController iOS/Android App.
 *    Type something from the Terminal to send
 *    to the BLEController App or vice verse.
 *    Characteristics received from App will print on Terminal.
 */
 
#include "mbed.h"
#include "ble/BLE.h"


#include "TxPower.h"
//#include "DFUService.h"

#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20
#define DIGITAL_OUT_PIN                  P0_17  //D7

//構成情報
const static char     CONFIG_INFO[]        = "OL"; // change this

// TX POWER用
#include "ble_gap.h"
#define TX_POWER                         0
//機器設定
//#define TX_ZERO                         
//#define TX_POWER_CALI                    -10
//const static char     DEVICE_NAME[]        = "nRF51DK"; // change this

//#define TX_POWER_CALI                      -7
//const static char     DEVICE_NAME[]        = "51822"; // change this

//#define TX_POWER_CALI                    -15
//const static char     DEVICE_NAME[]        = "Nano"; // change this

#define TX_POWER_CALI                      -10
const static char     DEVICE_NAME[]        = "MN4"; // change this


//反映してない　二箇所設定変更する場所ある
//static int tx_power = TX_POWER + TX_POWER_CALI;

BLE  ble;

Serial pc(USBTX, USBRX);
Ticker steper;
DigitalOut led1(DIGITAL_OUT_PIN);
DigitalOut ledori1(LED1);
//DFUService dfu(ble);

PwmOut servo1(P0_23);
//DigitalOut tran(P0_19);

// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

// The Service
//static const uint8_t uart_base_uuid[] = {0x02, 0xF3, 0xF5, 0x38, 0x8D, 0x11, 0x48, 0x02, 0xB6, 0xFC, 0xFB, 0x66, 0x16, 0xD4, 0xCD, 0x70}; //Service
//static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_送信用
//static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_受信用
//static const uint8_t uart_base_uuid_rev[] = {0x70, 0xCD, 0xD4, 0x16, 0x66, 0xFB, 0xFC, 0xB6, 0x02, 0x48, 0x11, 0x8D, 0x38, 0xF5, 0xF3, 0x02};

// MSC UUID
static const uint8_t msc_uuid[]   = {0x71, 0x3D, 0, 6, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用
uint8_t mscPayload[TXRX_BUF_LEN] = {0,};
static uint8_t msc_buf[TXRX_BUF_LEN];
static uint8_t msc_len=0;
GattCharacteristic  mscCharacteristic (msc_uuid, mscPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ); //tx power characteristic

// TX POWER用
static const uint8_t power_level_uuid[]   = {0x71, 0x3D, 0, 4, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用
uint8_t powerPayload[TXRX_BUF_LEN] = {0,};
static uint8_t power_buf[TXRX_BUF_LEN];
static uint8_t power_len=0;
GattCharacteristic  txPowerCharacteristic (power_level_uuid, powerPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ); //tx power characteristic
Ticker txSteper;

//Feature UUID
static const uint8_t feature_uuid[]   = {0x71, 0x3D, 0, 5, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用
uint8_t featurePayload[TXRX_BUF_LEN] = {0,};
static uint8_t feature_buf[TXRX_BUF_LEN];
static uint8_t feature_len=0;
GattCharacteristic  featureCharacteristic (feature_uuid, featurePayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ); //tx power characteristic


// Tx Power Service
//static const uint8_t power_base_uuid[] = {0x03, 0xF3, 0xF5, 0x38, 0x8D, 0x11, 0x48, 0x02, 0xB6, 0xFC, 0xFB, 0x66, 0x16, 0xD4, 0xCD, 0x70}; //Service
//static const uint8_t power_base_uuid_rev[] = {0x70, 0xCD, 0xD4, 0x16, 0x66, 0xFB, 0xFC, 0xB6, 0x02, 0x48, 0x11, 0x8D, 0x38, 0xF5, 0xF3, 0x03};
//static const uint8_t power_level_uuid[]   = {0x71, 0x3D, 0, 4, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E}; //central_TxPower受信用

/*
static const uint16_t txpower_base_uuid[] = {0x18, 0x04};
static const uint16_t txpower_base_uuid_rev[] = {0x04, 0x18};
*/
//02f3f538-8d11-4802-b6fc-fb6616d4cd70



uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

static uint8_t rx_buf[TXRX_BUF_LEN];
static uint8_t rx_len=0;

//Uart Service associated
GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic, &txPowerCharacteristic, &mscCharacteristic, &featureCharacteristic};
GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));

//TxPowerService *txPowerService = NULL;
//BatteryService *batteryService = NULL;
//uint8_t batteryLevel = 50;

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}

void ConnectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead, index;
    
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle())
    {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);
        pc.printf("WriteHandler \r\n");
        pc.printf("Length: ");
        pc.putc(bytesRead); //受け取った文字の先頭アドレス？
        pc.printf("\r\n");
        pc.printf("[0]: ");
        pc.putc(txPayload[1]); //１文字目を表示
        if(txPayload[1]=='a') {
            pc.printf("yeahhhhhh!!!!!!!!");
//            if(led1 == 0) {
                led1 = 1;
                ledori1 = 0;
                
            //tran = 1;
            //wait(0.5);
            for(float pwidth=0.001; pwidth<=0.0013; pwidth+=0.0001) { // 1ms ~ 2ms
              servo1.pulsewidth(pwidth); // pulse servo out
              wait(0.25);
            }
            //wait(0.5);
            //tran = 0;
                
//            } else {
//                led1 = 0;
//            }
        } else if(txPayload[1]=='b') {
            led1 = 0;
            ledori1 = 1;
        }
        pc.printf("\r\n");
        pc.printf("Data: ");
        for(index=0; index<bytesRead; index++)
        {
            pc.putc(txPayload[index]);
        }
        pc.printf("\r\n");
    }
}

// TX POWER用
void txPowerUpdate(int newTxPower) {
    sd_ble_gap_tx_power_set(newTxPower);
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%d", newTxPower + TX_POWER_CALI);
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(txPowerCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
}


// MSC UUID
void initMsc() {
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%s", "00000007");
    //sprintf(bufbuf_c, "%d", "02f3f538-8d11-4802-b6fc-fb6616d4cd70");
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(mscCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
}


// Feature
void initFeature() {
    //ここから-------------
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%s", "Out.AirCon");
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(featureCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
    //ここまで-------------
    //をこぴればデータを送信可能
}



void txStep() {
    //ここから-------------
    //sd_ble_gap_tx_power_set(TX_POWER);
    char bufbuf_c[20];
    uint8_t bufbuf[40];
    sprintf(bufbuf_c, "%d", TX_POWER + TX_POWER_CALI);
    int a;
    for(a=0; bufbuf_c[a] != '\0'; a++) {
        bufbuf[a] = bufbuf_c[a];
    }
    ble.updateCharacteristicValue(txPowerCharacteristic.getValueAttribute().getHandle(), bufbuf, a);
}
//-------------------

void initChara() {
    initMsc();
    initFeature();
    txStep();
}

void uartCB(void)
{   
    while(pc.readable())    
    {
        rx_buf[rx_len++] = pc.getc();    
        if(rx_len>=20 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n')
        {
            txPowerUpdate(TX_POWER);
            
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
            pc.printf("RecHandler \r\n");
            pc.printf("Length: ");
            pc.putc(rx_len);
            pc.printf("\r\n");
            rx_len = 0;
            break;
        }
    }
}

int main(void)
{
    //tran = 1;
    //float pwidth;
    servo1.period_ms(20);// pulse cycle = 20ms
    //servo1.pulsewidth(0.001);
    wait(0.25);
    for(float pwidth=0.001; pwidth<=0.0013; pwidth+=0.0001) { // 1ms ~ 2ms
        servo1.pulsewidth(pwidth); // pulse servo out
        wait(0.25);
    }
    
    led1 = 0;
    ledori1 = 0;
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);
    ble.onConnection(ConnectionCallback);
    
    pc.baud(9600);
    pc.printf("SimpleChat Init \r\n");
    
    pc.attach( uartCB , pc.RxIrq);
    
   //txPowerService = new TxPowerService(ble, -40);
   //txPowerService->updateTxPower(TX_POWER);
    
        
    //TxPowerService tx(ble, -40); // setting up the service and assigning an initial value
    //tx.updateTxPower(TX_POWER);    //changing the initial value just for testing ....   
    
   // setup advertising 
//    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)txpower_base_uuid_rev, sizeof(txpower_base_uuid_rev));
    
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME) - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));


    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(50);

    ble.addService(uartService);
    
    ble.setScanParams(GapScanningParams::SCAN_INTERVAL_MIN,
                      GapScanningParams::SCAN_WINDOW_MIN,
                      0);
                      
    ble.startAdvertising(); 
    pc.printf("Advertising Start \r\n");
   
    //TX POWER用
    txPowerUpdate(TX_POWER);
    //txSteper.attach(&initChara, 1.0);

    initChara();
    //wait(0.5);
    //tran = 0;
    while(1)
    {
     ble.waitForEvent(); 
    }
}


