
 //Includes
#include "mbed.h"
#include "SDFileSystem.h"                       // Sd-Card Libray
#include "USBSerial.h"


//SD Card
#define MOSI        PA_7
#define MISO        PA_6
#define sclk        PA_5
#define cs          PB_6


//USART
USBSerial pc(0x1f00, 0x2012, 0x0001, false);

//SD Pinout
SDFileSystem sd(MOSI, MISO, sclk, cs, "sd");

//Variables
FILE *SDsave;




//Main program
int main(){
    //Ouverture du fichier SD
    SDsave= fopen("/sd/SBraTests.txt", "w");        // Open the .txt file
    pc.printf(" initialisation SD OK\t");
    
    //Sauvegarde des données
    pc.printf(" %0.2f", 30.4152);            //Affichage pour validation
    fprintf(SDsave, "%0.3f\t", 30.4152);     // Savegarde sur carte SD
            
    if(SDsave == NULL) { error("Could not open file for write\n");} 
    
    //Retours à la ligne
    fprintf(SDsave, "\n");
    pc.printf(" \n\r");
        
    //Fermeture du fichier
    fclose(SDsave);
    pc.printf("Finish\n");
}
        
        
    
