
#include "mbed.h"
#include "MBed_Adafruit_GPS.h"
#include "USBSerial.h"
#include "SDFileSystem.h"


USBSerial pc(0x1f00, 0x2012, 0x0001, false);
Serial * gps_Serial;
SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd");
Timer dt ; int t_avant = 0 ; int t_m = 0  ; int t_d = 0; int t_apres = 0; 

PwmOut Green(PC_8); //PWM Red LED
PwmOut Red(PC_6); //PWM Green LED
PwmOut Blue(PC_9); //PWM Blue LED
int i = 0;
float lat_dd, lon_dd;
float lat_1, lon_1;
float lat_2, lon_2;
float height = 171;
float distance = 0;
//float distance1 = 0;
//float distance2 = 0;
float sum_distance = 0;
float steps = 0;
double avg_speed = 0;
float cal = 0;

int main()
{

    dt.start(); 
    Blue = 0;
    gps_Serial = new Serial(PA_2,PA_3); //serial object for use w/ GPS
    Adafruit_GPS myGPS(gps_Serial); //object of Adafruit's GPS class
    char c; //when read via Adafruit_GPS::read(), the class returns single character stored here
    Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 2000; //refresh time in ms
    myGPS.begin(9600);  //sets baud rate for GPS communication; note this may be changed via Adafruit_GPS::sendCommand(char *)
    //a list of GPS commands is available at http://www.adafruit.com/datasheets/PMTK_A08.pdf
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA); //these commands are defined in MBed_Adafruit_GPS.h; a link is provided there for command creation
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    FILE *fp = fopen("/sd/GPS_Test.txt", "w");
    wait(1);
    refresh_Timer.start();  //starts the clock on the timer
    while(true) {
        c = myGPS.read();   //queries the GPS
        Blue = 0;
        if (c) { } //this line will echo the GPS data if not paused
        //check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                continue;
            }
        }

        //check if enough time has passed to warrant printing GPS info to screen
        //note if refresh_Time is too low or pc.baud is too low, GPS data may be lost during printing
        if (refresh_Timer.read_ms() >= refresh_Time) {
            refresh_Timer.reset();
            fprintf(fp,"Time: %d:%d:%d.%u\n", myGPS.hour+1, myGPS.minute, myGPS.seconds, myGPS.milliseconds);
            fprintf(fp,"Date: %d/%d/20%d\n", myGPS.day, myGPS.month, myGPS.year);
            fprintf(fp,"Fix:. %d\n", (int) myGPS.fix);
            fprintf(fp,"Quality: %d\n\n", (int) myGPS.fixquality);

            pc.printf("Time: %d:%d:%d.%u\n", myGPS.hour+1, myGPS.minute, myGPS.seconds, myGPS.milliseconds);
            pc.printf("Date: %d/%d/20%d\n", myGPS.day, myGPS.month, myGPS.year);
            pc.printf("Fix: %d\n", (int) myGPS.fix);
            pc.printf("Quality: %d\n\n", (int) myGPS.fixquality);
            Blue = 0;
            if (myGPS.fix) {
                lat_dd = myGPS.coordToDegDec(myGPS.latitude);
                lon_dd = myGPS.coordToDegDec(myGPS.longitude);
                if (i == 0) {
                    lat_1 = lat_dd;lon_1 = lon_dd;lat_2 = lat_1;lon_2 = lon_1;t_m = dt.read_ms() ; t_m = dt.read(); 

                }   else    {
                    lat_1 = lat_2;lon_1 = lon_2;lat_2 = lat_dd;lon_2 = lon_dd;t_apres = t_m ; t_m = dt.read(); t_d = t_apres - t_m ; 
                    ::distance =  myGPS.getDistance(lat_1, lon_1, lat_2, lon_2 );
                    ::sum_distance += ::distance;
                    ::steps = myGPS.getSteps(::sum_distance, height);   
                    ::avg_speed = myGPS.getAvgSpeed(::sum_distance, t_d );}


                //fprintf(fp,"t: %d\n", i);
                fprintf(fp,"Satellites : %d\n", myGPS.satellites);
                fprintf(fp,"Location (deg) : %5.5f%c, %5.5f%c\n", lat_dd, myGPS.lat, lon_dd, myGPS.lon);
                //fprintf(fp,"Location1 (°) : %5.5f, %5.5f\n", lat_1, lon_1);
                //fprintf(fp,"Location2 (°) : %5.5f, %5.5f\n", lat_2, lon_2);
                //fprintf(fp,"Speed: %5.2f knots\n", myGPS.speed);
                //fprintf(fp,"Angle: %5.2f\n", myGPS.angle);
                fprintf(fp,"Altitude (m) : %5.2f\n", myGPS.altitude);
                fprintf(fp,"Distance (m) : %5.2f\n", ::sum_distance);
                fprintf(fp,"Steps taken : %5.0f\n", ::steps);
                fprintf(fp,"Average speed (km/h) : %5.2f\n\n\n", ::avg_speed);

                //pc.printf("t: %d\n", i);
                pc.printf("Satellites : %d\n", myGPS.satellites);
                pc.printf("Location (deg) : %5.5f%c, %5.5f%c\n", lat_dd, myGPS.lat, lon_dd, myGPS.lon);
                //pc.printf("Location (°) : %5.5f%c, %5.5f%c\n", lat_dd, myGPS.lat, lon_dd, myGPS.lon);
                //pc.printf("Location1 (°) : %5.5f, %5.5f\n", lat_1, lon_1);
                //pc.printf("Location2 (°) : %5.5f, %5.5f\n", lat_2, lon_2);
                //pc.printf("Speed: %5.2f knots\n", myGPS.speed);
                //pc.printf("Angle: %5.2f\n", myGPS.angle);
                pc.printf("Altitude (m) : %5.2f\n", myGPS.altitude);
                pc.printf("Distance (m) : %5.2f\n", ::sum_distance);
                pc.printf("Steps taken : %5.0f\n", ::steps);
                pc.printf("Average speed (km/h) : %5.5f\n\n\n", ::avg_speed);



                Blue = 1;
                i++;

            }
            wait(0.5);
        }
    }
    fclose(fp);                                                     // Closing the file
    if(fp == NULL) {
        error("Could not open file for write\n");    // Error message, if  there is a problem
    }
}


/*

//gps.cpp
//for use with Adafruit Ultimate GPS
//Reads in and parses GPS data

#include "mbed.h"
#include "MBed_Adafruit_GPS.h"

Serial * gps_Serial;
Serial pc (USBTX, USBRX);

int main() {

   pc.baud(115200); //sets virtual COM serial communication to high rate; this is to allow more time to be spent on GPS retrieval

   gps_Serial = new Serial(p28,p27); //serial object for use w/ GPS
   Adafruit_GPS myGPS(gps_Serial); //object of Adafruit's GPS class
   char c; //when read via Adafruit_GPS::read(), the class returns single character stored here
   Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
   const int refresh_Time = 2000; //refresh time in ms

   myGPS.begin(9600);  //sets baud rate for GPS communication; note this may be changed via Adafruit_GPS::sendCommand(char *)
                       //a list of GPS commands is available at http://www.adafruit.com/datasheets/PMTK_A08.pdf

   myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA); //these commands are defined in MBed_Adafruit_GPS.h; a link is provided there for command creation
   myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
   myGPS.sendCommand(PGCMD_ANTENNA);

   pc.printf("Connection established at 115200 baud...\n");

   wait(1);

   refresh_Timer.start();  //starts the clock on the timer

   while(true){
       c = myGPS.read();   //queries the GPS

       if (c) { pc.printf("%c", c); } //this line will echo the GPS data if not paused

       //check if we recieved a new message from GPS, if so, attempt to parse it,
       if ( myGPS.newNMEAreceived() ) {
           if ( !myGPS.parse(myGPS.lastNMEA()) ) {
               continue;
           }
       }

       //check if enough time has passed to warrant printing GPS info to screen
       //note if refresh_Time is too low or pc.baud is too low, GPS data may be lost during printing
       if (refresh_Timer.read_ms() >= refresh_Time) {
           refresh_Timer.reset();
           pc.printf("Time: %d:%d:%d.%u\n", myGPS.hour, myGPS.minute, myGPS.seconds, myGPS.milliseconds);
           pc.printf("Date: %d/%d/20%d\n", myGPS.day, myGPS.month, myGPS.year);
           pc.printf("Fix: %d\n", (int) myGPS.fix);
           pc.printf("Quality: %d\n", (int) myGPS.fixquality);
           if (myGPS.fix) {
               pc.printf("Location: %5.2f%c, %5.2f%c\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
               pc.printf("Speed: %5.2f knots\n", myGPS.speed);
               pc.printf("Angle: %5.2f\n", myGPS.angle);
               pc.printf("Altitude: %5.2f\n", myGPS.altitude);
               pc.printf("Satellites: %d\n", myGPS.satellites);
           }
       }
   }
}
*/


/*

//gps.cpp
//for use with Adafruit Ultimate GPS
//Reads in and parses GPS data

#include "mbed.h"
#include "MBed_Adafruit_GPS.h"

Serial * gps_Serial;
Serial pct (USBTX, USBRX);

int main() {

    pct.baud(115200); //sets virtual COM serial communication to high rate; this is to allow more time to be spent on GPS retrieval

    gps_Serial = new Serial(PTC17,PTC16); //serial object for use w/ GPS
    Adafruit_GPS myGPS(gps_Serial); //object of Adafruit's GPS class
    char c; //when read via Adafruit_GPS::read(), the class returns single character stored here
    Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 2000; //refresh time in ms

    myGPS.begin(9600);  //sets baud rate for GPS communication; note this may be changed via Adafruit_GPS::sendCommand(char *)
                        //a list of GPS commands is available at http://www.adafruit.com/datasheets/PMTK_A08.pdf

    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA); //these commands are defined in MBed_Adafruit_GPS.h; a link is provided there for command creation
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);

    pct.printf("Connection established at 115200 baud...\n");

    wait(1);

    refresh_Timer.start();  //starts the clock on the timer

    while(true){
        c = myGPS.read();   //queries the GPS

        if (c) { pct.printf("%c", c); } //this line will echo the GPS data if not paused

        //check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                continue;
            }
        }

        //check if enough time has passed to warrant printing GPS info to screen
        //note if refresh_Time is too low or pc.baud is too low, GPS data may be lost during printing
        if (refresh_Timer.read_ms() >= refresh_Time) {
            refresh_Timer.reset();
            pct.printf("Time: %d:%d:%d.%u\n", myGPS.hour, myGPS.minute, myGPS.seconds, myGPS.milliseconds);
            pct.printf("Date: %d/%d/20%d\n", myGPS.day, myGPS.month, myGPS.year);
            pct.printf("Fix: %d\n", (int) myGPS.fix);
            pct.printf("Quality: %d\n", (int) myGPS.fixquality);
            if (myGPS.fix) {
                pct.printf("Location: %5.2f%c, %5.2f%c\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
                pct.printf("Speed: %5.2f knots\n", myGPS.speed);
                pct.printf("Angle: %5.2f\n", myGPS.angle);
                pct.printf("Altitude: %5.2f\n", myGPS.altitude);
                pct.printf("Satellites: %d\n", myGPS.satellites);
            }

        }

    }


}

*/