/* 
https://os.mbed.com/docs/v5.7/reference/serial.html 
https://fr.wikiversity.org/wiki/Langage_C/Entr%C3%A9es-sorties 
*/

#include "mbed.h"

// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity Configuration du port COM
Serial pc(SERIAL_TX, SERIAL_RX); //Association à pc le port série de l’interface ST-link
DigitalOut myled(LED1);

//Exemple 1 : écriture sur le port COM

int main()
        { int i = 1; // Variable locale i mise à 1
        pc.printf("Hello World !\n"); //Impression sur le port pc de Hello world
        
        while(1) {
                    wait(1);
                    pc.printf("This program runs since %d seconds.\n", i++); //Impression sur le port pc de …
                    myled = !myled;
                }
        }       

/*
//Exemple 2 : Lecture sur le port COM 
// https://os.mbed.com/docs/v5.7/reference/serial.html


int main()
{
pc.printf("Press '1' to turn LED1 ON, '0' to turn it OFF\n");
while(1) {
            char c = pc.getc(); // Read hyperterminal
            if (c == '0') {
                            led = 0; // OFF
                            }
            if (c == '1') {
                            led = 1; // ON
                            }
        }
}

*/

/*
// Exemple 3 : utilisation de scanf et printf
int main() {
            int num;
            while(1) {
                        pc.printf("Input any integer number: ");
                        pc.scanf("%i", &num);
                        pc.printf("\r\nnum = %d\r\n", num);
                        pc.printf("num^2 = %d\r\n", num*num);
                        }
            }
*/

/* 
//Example 3 : utilisation de pointeurs
int main(void)
{
while (1) {
            int value = 0;
            int *pValue = &value; // Set pointer to refer to value.
            pc.printf ("Enter an integer: ");
            pc.scanf(" %d", pValue); // Read into value via the pointer.
            pc.printf("You entered %d (base 10).\n", value); // Display the value entered.
            pc.printf("Which is %x (base 16).\n", value); // Display the value entered.
            pc.printf("Done. Now I sleep.\n");
            wait(2);
            }
}

*/