/* https://os.mbed.com/docs/v5.7/reference/timer.html

Use the Timeout interface to set up an interrupt to call a function after a specified delay.
You can create any number of Timeout objects, allowing multiple outstanding interrupts at the same time.
Warnings and notes
Timers are based on 32-bit int microsecond counters, so they can only time up to a maximum of 2^31-1 microseconds (30 minutes). They are designed for times between microseconds and seconds. For longer times, you should consider the time() real time clock.
No blocking code in ISR: avoid any call to wait, infinite while loop or blocking calls in general.
No printf, malloc or new in ISR: Avoid any call to bulky library functions. In particular, certain library functions (such as printf, malloc and new) are not re-entrant, and their behavior could be corrupted when called from an ISR.
*/

#include "mbed.h"

/* Example 1: 
Timeout flipper;
DigitalOut led1(LED1);

void flip() {
            led1 = !led1;
            }

int main() {
            led2 = 1;
            flipper.attach(&flip, 2.0); // setup flipper to call flip after 2 seconds
                                        // spin in a main loop. flipper will interrupt it to call flip

while(1) {
            }
           }
           
*/

/*Example 2:

// A class for flip()-ing a DigitalOut

class Flipper {
                public:
                Flipper(PinName pin) : _pin(pin) {
                                                    _pin = 0;
                                                  }
void flip() {
                _pin = !_pin;
            }

                private:
                DigitalOut _pin;
              };
              
Flipper LED(LED1);
Timeout t;

int main() {
                // the address of the object, member function, and interval
            t.attach(callback(&LED, &Flipper::flip), 2.0);
                // spin in a main loop. flipper will interrupt it to call flip

while(1) {
          }
           }
           
*/