/*
https://fr.wikipedia.org/wiki/I2C
https://os.mbed.com/docs/v5.7/reference/i2c.html
https://os.mbed.com/docs/v5.7/reference/i2cslave.html
http://ww1.microchip.com/downloads/en/devicedoc/21462d.pdf
*/

#include "mbed.h"

I2C i2c(PB_9, PB_8);        // ports sda, scl
Serial pc(USBTX, USBRX);    // tx, rx terminal
const int addr = 0x90;      // define the I2C Address for TC74-A0 1001 000 0<-- R/W bit

int main()
            {
                int temp = 0;
                int a,b,c;
                char cmd[2];
                wait(1);    //Make sure system is fully initialized
                pc.printf("\r\n\nStart reading the temperature of TC74 on I2C\r\n");
while(1) {
    
                //Method 1
                //Using low level functions
            i2c.start();            // Start condition
            a = i2c.write(addr);    // Write Device Address
            b = i2c.write(0x00);    // Write READ command of TC74 (voir page 8 de la datasheet du TC74)
            i2c.start();            // Reissue start condition

                //Instead Stop condition and Start again
            c= i2c.write(addr|1);   //Device Adress read mode
            temp = i2c.read(0);     //Temp register value reading
            i2c.stop();             //I2C stop

                //Method 2
                //Using high level functions
                
            cmd[0] = 0x0;           //Command :: READ
            cmd[1] = 0x0;           //Param :: Unused in this case
            i2c.write(addr, cmd, 1);//Issue required command to perform a write of the command
            i2c.read(addr, cmd, 1); //Read the Data from the device

//-----------------Print out section ----------------------

                //Display device Address and informations
            pc.printf("Device with address 0x%x \r\n", addr);

                //Prints out the result of Method 1
                //pc.printf("ACK1 :: %d\n\rACK2 :: %d\n\rACK3 :: %d\n\r", a,b,c); //ACK bits verification
            pc.printf("Method 1 Temp = %d\n", temp);

                //Prints out the Data from Method 2
            pc.printf("Method 2 Temp = %d\n\r", cmd[0]);
            wait(1);
        }
    }