//Includes

#include "mbed.h"
#include "SimpleBLE.h"
#include "LIS3DH.h"

//Accelerometer

#define MOSI PC_12
#define MISO PC_11
#define CS PC_5
#define SCLK PC_10

//Init simpleBLE

SimpleBLE ble("ObCP_CROC_ENSMM");


// GPIO set

//Interrupt input

InterruptIn user1(PC_13);  //User1

//PWM output

PwmOut PWMoutput(PB_1);          //Main PWM output
PwmOut Green(PC_8);              //PWM Red LED
PwmOut Red(PC_6);                //PWM Green LED
PwmOut Blue(PC_9);               //PWM Blue LED

//Init accelerometer

LIS3DH      acc(MOSI, MISO, SCLK, CS, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_2G);

// Characteristics Accelerometer input

SimpleChar<float> accX = ble.readOnly_float(0xA000, 0xA002);
SimpleChar<float> accY = ble.readOnly_float(0xA000, 0xA003);
SimpleChar<float> accZ = ble.readOnly_float(0xA000, 0xA004);


// When characteristic LED RGB changing

void LEDupdate(uint32_t newColor)
{
    // read individual bytes
    uint8_t* channels = (uint8_t*)&newColor;

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    Red   = static_cast<float>(channels[0]) / 255.0f;
    Green = static_cast<float>(channels[1]) / 255.0f;
    Blue  = static_cast<float>(channels[2]) / 255.0f;
}

// When characteristic PWM output changing

void PWMupdate(uint8_t pwmvalue)
{

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    PWMoutput   = static_cast<float>(pwmvalue) / 255.0f;
}

// When characteristic input changing
void Accupdate()
{

    accX = float(short((acc.read_reg(LIS3DH_OUT_X_H) << 8) | acc.read_reg(LIS3DH_OUT_X_L))) * 0.001F / 15;
    accY = float(short((acc.read_reg(LIS3DH_OUT_Y_H) << 8) | acc.read_reg(LIS3DH_OUT_Y_L))) * 0.001F / 15;
    accZ = float(short((acc.read_reg(LIS3DH_OUT_Z_H) << 8) | acc.read_reg(LIS3DH_OUT_Z_L))) * 0.001F / 15;

}

// Characteritic PWM LED RGB
SimpleChar<uint32_t> color = ble.writeOnly_u32(0x6200, 0x6201, &LEDupdate);

// Characteristic PWM output
SimpleChar<uint8_t> pwmout = ble.writeOnly_u8(0xA000, 0xA001, &PWMupdate);


//Main program

int main(int, char**)
{

    ble.start();
    Ticker t;
    t.attach(&Accupdate, 5.0f);

    while (1) {
        ble.waitForEvent();

    }
}
