/*      MEMOS 

Addresses of the different sensors TMP117 :
            112 (Decimel) = 70 (Hexadecimal)
            116 (Decimel) = 74 (Hexadecimal)

Addresses of the different sensors TMP117 :
              Ground  1001000x (0x90/0x91)                      Address 1 
              V+      1001001x (0x92/0x93)                      Address 2
              SDA     1001010x (0x94/0x95)                      Address 3
              SCL     1001011x (0x96/0x97)                      Address 4
*/


int Intervalle_Mesures = 300;      //Choix de l'intervalle de mesure en sec



 //Includes
#include "mbed.h"
#include "SimpleBLE.h"
#include "tca9548a.h"                           // tca954a  libary
#include "SDFileSystem.h"                       // Sd-Card Libray
Timer timer;
#include "USBSerial.h"

#define I2C_SDA                  PB_9           // The µcontrolleur SDA 
#define I2C_SCL                  PB_8           // The µcontrolleur SCL

//SD Card
#define MOSI        PA_7
#define MISO        PA_6
#define sclk        PA_5
#define cs          PB_6


//USART
USBSerial pc(0x1f00, 0x2012, 0x0001, false);

//Init simpleBLE
SimpleBLE ble("SBRA");

// Multiplexeurs
TCA9548A i2c_sw1(I2C_SDA, I2C_SCL, 0x70);                          
TCA9548A i2c_sw2(I2C_SDA, I2C_SCL, 0x74);

//Voie I2C du F411
I2C i2c(I2C_SDA, I2C_SCL);

//SD Pinout
SDFileSystem sd(MOSI, MISO, sclk, cs, "sd");

//Interrupt input
InterruptIn button(PC_13); //User1



//Variables
FILE *SDsave;
float tmp[64];
char cmd[2];
//Sensors Address
char ADD[8];
    
    
// Characteristics BLE_Sensors input
SimpleChar<float> T11 = ble.readOnly_float(0xA000, 0xA002);
SimpleChar<float> T21 = ble.readOnly_float(0xA000, 0xA006);
SimpleChar<float> T31 = ble.readOnly_float(0xA000, 0xA010);



void SD(int Save){

    if (Save == 2){ 
    SDsave= fopen("/sd/SBraTests.txt", "w");        // Open the .txt file
    pc.printf(" initialisation SD OK\t");
    }
    
    if (Save == 1){
        //SD Save
        for (int z=0; z<=63; z++){
            pc.printf(" %0.2f", tmp[z]);            //Affichage pour validation
            fprintf(SDsave, "%0.3f\t", tmp[z]);     // Savegarde sur carte SD
            
            if(SDsave == NULL) { error("Could not open file for write\n");}     
        }
        fprintf(SDsave, "\n");
        pc.printf(" \n\r");
    }
    
    if (Save == 3){
        fclose(SDsave);
        pc.printf("Finish\n");
    }
}


void Sensors(int Lecture){
    if (Lecture == 0){
        //Initialisation des capteurs
        for (int channel=0; channel<=7; channel++){
            i2c_sw1.select(channel);
            for (int i=0; i<=6;){
                cmd[0] = 0x01;
                cmd[1] = 0x00;
        
                i2c.write(ADD[i+1], cmd, 2);
                cmd[0] = 0x00;
                i2c.write(ADD[i+1], cmd, 1);
        
                wait(0.3);
                i = i + 2;
            }
            wait(0.3);
        
            i2c_sw2.select(channel);
            wait(0.1);
            for (int i=0; i<=6;){
                cmd[0] = 0x01;
                cmd[1] = 0x00;
        
                i2c.write(ADD[i+1], cmd, 2);
                cmd[0] = 0x00;
                i2c.write(ADD[i+1], cmd, 1);
        
                wait(0.3);
                i = i + 2;
            }
        }
        pc.printf(" initialisation Sensors OK\t");
    }
    
    if (Lecture == 1){
        int num_capteur = 0;
        //Valeurs du multiplexeur n°1
        for (int channel=0; channel<=7; channel++){
            i2c_sw1.select(channel);
            //Lecture des sensors de chaine selectionne
            for (int i=0; i<=6;){
                cmd[0] = 0;
                cmd[1] = 0;
            
                i2c.read(ADD[i], cmd, 2);
                wait(0.1);
        
                float x = float(cmd[0])*2;
                float y = float(cmd[1])*0.0078125;
                tmp[num_capteur] = x + y;
                //printf(" %0.2f", x+y);//*********
                i = i+2;
                num_capteur++;
            }
        }
        wait(0.1);
        //Valeurs du multiplexeur n°2
        for (int channel=0; channel<=7; channel++){
            i2c_sw2.select(channel);
            //Lecture des sensors de chaine selectionne
            for (int i=0; i<=6;){
                cmd[0] = 0;
                cmd[1] = 0;
            
                i2c.read(ADD[i], cmd, 2);
                wait(0.1);
        
                float x = float(cmd[0])*2;
                float y = float(cmd[1])*0.0078125;
                tmp[num_capteur] = x + y;
                //printf(" %0.2f", x+y);//*****
                i = i+2;
                num_capteur++;
            }
        }
        SD(1);
    }
}

// When characteristic input changing
void Accupdate()
{
    T11 = tmp[0];
    T21 = tmp[4];
    T31 = tmp[8];
}

//Main program
int main(){
    
    timer.start();
    float time, time1;
    
    time = timer.read_ms()/1000;
//Sensors Address 1
    ADD[0]=0x90;
    ADD[1]=0x91;
//Sensors Address 2
    ADD[2]=0x92;
    ADD[3]=0x93;
//Sensors Address 3
    ADD[4]=0x94;
    ADD[5]=0x95;
//Sensors Address 4
    ADD[6]=0x96;
    ADD[7]=0x97;
    
    pc.printf("Initialiation...\t");
    
    Sensors(0);
    SD(2);
    wait(2);
    ble.start();
    Ticker t;
    t.attach(&Accupdate, 5.0f);
    
    pc.printf("Initialisation OK\t");
    pc.printf(" \n\r");

    while (button == 1) {
        time1 = timer.read_ms()/1000;
        ble.waitForEvent();
        
        if (time1-time>Intervalle_Mesures){
            Sensors(1);
            time=timer.read_ms()/1000;
            time1=timer.read_ms()/1000;
        }
    }SD(3);
}
        
        
    
