/*
Programme pour l'ObCP connecté à la fois à l'autre ObCP et à l'application Android
C'est la cellule qui fait la porte d'arrivée en mode solo
La sortie de la photodiode est reliée à la broche A0
Le laser est alimenté en 3V3 (suffisant) ou en 5V.
Les pattes RX et TX dumodule HC-05 sont reliées aux broches D0 et D1 (Attention à relier RX à TX et Tx à RX)
Le shield est fonctionnel (sauf BLE) mais il faut inverser TX et RX pour le HC-05/HC06
Il comporte aussi 2 leds, 2 boutons, et un transistor pour controler le laser.
*/
/*
Penser à mettre à jour les librairies
*/

  //Includes

#include "mbed.h"
#include "SimpleBLE.h"
#include "stdlib.h"


//Bluetooth hc05-6
//USBTX et USBRX sont utilisés
#define TX D0
#define RX D1

//Init simpleBLE

SimpleBLE ble("ObCP_Roller_Catcher2");


// GPIO set

//Interrupt input

InterruptIn user1(PC_13);  //User1
InterruptIn boutton1(D3);  //Bouton 1 shield
InterruptIn boutton2(D4);  //Bouton 2 shield 
InterruptIn event(A0);     //Passage dans la porte laser 

//Création du Timer

Timer timer;

//Sorties numériques

DigitalOut led1(D14);
DigitalOut transistor(D6);

//PWM output

PwmOut PWMoutput(PB_1);          //Main PWM output
PwmOut Green(PC_8);              //PWM Red LED
PwmOut Red(PC_6);                //PWM Green LED
PwmOut Blue(PC_9);               //PWM Blue LED

//Création des variables

float flag = 0;
bool flag2=false;
int c;
int temps1;
int tref;
char message ;
float end,begin;
int temps2 =0;


//Création des liaisons série (pc et bluetooth hc-05)

//Serial pc(USBTX, USBRX);
Serial BT(USBTX,USBRX);

// Characteristics pour affiche sur l'appli Android via BLE

SimpleChar<float> compteur = ble.readOnly_float(0xA000, 0xA003);
SimpleChar<float> Temps = ble.readOnly_float(0xA000, 0xA004);
SimpleChar<float> Temps2 = ble.readOnly_float(0xA000, 0xA007);


void envoi(char message)
{
    BT.printf("%c\n", message);
}

void resetUpdate(float rst)
{
    message = 'R';
    envoi(message);
    timer.reset();
    tref=timer.read_ms();
}

// Changement de mode de course ou changements couleur led

void LEDupdate(uint32_t newColor)
{
    // read individual bytes
    uint8_t* channels = (uint8_t*)&newColor;

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    Red   = static_cast<float>(channels[0]) / 255.0f;
    Green = static_cast<float>(channels[1]) / 255.0f;
    Blue  = static_cast<float>(channels[2]) / 255.0f;
    flag  = static_cast<float>(channels[3]);
    

    if(flag == 1) {
        //  pc.printf("Mode duo actif");
        message = 'D';
        envoi(message);
        timer.reset();
        flag2=true;
    }else if(flag == 0) {
        //  pc.printf("Mode solo actif   ");
        message = 'S';
        envoi(message);
        timer.reset();
        flag2=false;
    }
}

void pressed2(){
    led1 = !led1;
    temps2 = timer.read_ms();
    
    if(flag2==false){
        Temps=(temps2-(temps1+1040))/1000.0f;    //LE 1040 correspond au terme de correction du temps que nous avons calculé
        
    }else{
        Temps = (temps1+1040-tref)/1000.0f;
        Temps2 = (temps2-tref)/1000.0f;
    }
}

void arret_laser(){
    transistor = !transistor;
}



// Characteritic PWM LED RGB
SimpleChar<uint32_t> color = ble.writeOnly_u32(0x6200, 0x6201, &LEDupdate);

// Characteristic PWM output
//SimpleChar<uint8_t> pwmout = ble.writeOnly_u8(0xA000, 0xA001, &PWMupdate);

SimpleChar<float> reset = ble.writeOnly_float(0xA000, 0xA005, &resetUpdate);
SimpleChar<float> depart_course = ble.writeOnly_float(0xA000, 0xA006, &resetUpdate);


/*
void skater_d()
{
    if(flag==false) {
        //printf("Ligne de depart coupee solo \n");
        if( flag == false) {
            //printf("Depart skate \n");
            begin = timer.read_ms();
            compteur=100;
            //pc.printf("                                         skater lance %.0f \n", begin);
            flag = true;
        } else if(flag == true) {
            //printf("erreur \n");
            //pc.printf("                                                                      Temps du skater : %.0f \n", end-begin);
            flag = false;
        }
    }
    else if(flag==true) {
        //printf("Ligne d'arrivee coupee \n");
        if( flag == false ) {
            //printf("arrivee coupe sans depart\n");
            flag = true;
        } else if(flag == true ) {
            //printf("Arrivee skate \n");
            end = timer.read_ms();
            //Temps = end-begin;
            compteur=200;
            //wait(1);
            //pc.printf("                                                                      Temps du skater : %.0f \n", end-begin);
            flag = false;
        }
    } 
}
*/



void RXevent (){

    if(BT.readable()){
        BT.scanf("%i", &temps1);
    }    
}    


  

int main(int, char**)
{
    transistor=1;
    ble.start();
    timer.start();
    BT.attach(&RXevent);
    user1.fall(&pressed2);
    boutton1.fall(&arret_laser);
    //boutton2.fall(&pressed);
    event.fall(&pressed2);
    

    while (1) {
        ble.waitForEvent();
    }
}
