/*  https://os.mbed.com/docs/v5.7/reference/rtc.html
    The RTC (Real-Time Clock) class provides mechanisms to set the current time of the hardware RTC with set_time API. The time is set as an offset measured in seconds from the time epoch (Unix Epoch - January 1, 1970).
    
    https://fr.wikipedia.org/wiki/Heure_Unix
    
    https://www.epochconverter.com/programming/c
    
    You can use the attach_rtc API to hook external RTC for using C time functions. It provides you with init(), read(), write() and isenabled() functions to be attached. Time provides more information about C date and time standard library functions.
    RTC class APIs are thread safe. RTC can keep track of time even in a powered down state if the secondary source of power (battery) is connected.

    https://os.mbed.com/blog/entry/103/
    
*/

#include "mbed.h"

int main() {

                // Set the current time from the terminal

            struct tm t;
            printf("Enter current date and time:\n");
            printf("YYYY MM DD HH MM SS[enter]\n");
            scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday, &t.tm_hour, &t.tm_min, &t.tm_sec);

                // Adjust for tm structure required values
            t.tm_year = t.tm_year - 1900;
            t.tm_mon = t.tm_mon - 1;
                
                // Set the time
            set_time(mktime(&t));

                // Display the time

    while(1) {
                time_t seconds = time(NULL);
                printf("Time as a basic string = %s", ctime(&seconds));
                wait(1);
                char buffer[32];
                strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
                printf("Time as a custom formatted string = %s", buffer);
                wait(1);
            }
        }