// First program to measure the step response of the system

/*
#include "mbed.h"

AnalogIn LM35(A0);                    //LM35 on A0 analog input
PwmOut PWM(D3);                       //D3 as PWM output
InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);     // Def UART
float pwm_value;
float temp_value;
int time_value;

void pressed()
                {
                    pc.printf("Entrer la valeur de la sortie PWM :\n");
                    pc.scanf("%f", &pwm_value);
                    led=!led;                //Flip LED
                    pc.printf("La valeur de PWM est maintenant : %f\n", pwm_value); //print time and temp
                    PWM.write(pwm_value);   // PWM changing value
                    time_value = 0;         // init time
                }
                
int main()
            {
                pwm_value = 0;              //Init pwm_value
                temp_value = 0;             //Init temp_value
                time_value = 0;             //Init time
                PWM.period_ms(1);           //PWM period
                button.fall(&pressed);      //Pressed button interrupt
                PWM.write(0);               //Heating desactivate

while(1){
            temp_value = LM35.read();       //LM35 temp reading
            temp_value = temp_value * 330 ; //Conversion in °C
            pc.printf("%i %f \n", time_value, temp_value); //print time and temp
            wait(1);                        // temporisation 1s
            time_value++;                   // increment of time_value
        }
            }

*/

// https://os.mbed.com/users/aberk/code/PID/docs/6e12a3e5af19/classPID.html
// PID temp regulation program

/*
#include "mbed.h"
#include "PID.h"

AnalogIn LM35(A0);                  //Entréé analogique
PID controller(0, 0, 0, 1);
PwmOut PWM(D3);                     //Sortie PWM
InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);    // Déf. UART
float pwm_value;
float temp_value;
int time_value;
float pid_time;
float kp;
float ki;
float kd;
float temp_target;


void pressed()
                {
                    pc.printf("Temp cible = ?\n");
                    pc.scanf("%f", &temp_target);
                    pc.printf("Temp cible = %f\n",temp_target);
                    controller.setSetPoint(temp_target); //Set temp target
                }
                
int main()
            {
                pc.printf("Coeff. proportionnel = ?\n");
                pc.scanf("%f", &kp);
                pc.printf("Coeff. derive = ?\n");
                pc.scanf("%f", &kd);
                pc.printf("Coeff. integral = ?\n");
                pc.scanf("%f", &ki);
                pc.printf("Interval PID (s) = ?\n");
                pc.scanf("%f", &pid_time);
                pc.printf("kp = %f; kd = %f; ki = %f; PID time = %f \n", kp,kd,ki, pid_time); //print time and temp
                
                controller.setTunings(kp, ki, kd);
                controller.setInterval(pid_time);
                controller.setInputLimits(0.0, 60.0);   //Analog input from 0.0 to 3.3V
                controller.setOutputLimits(0.0, 1.0);   //Pwm output from 0.0 to 1.0
                controller.setBias(0.0);                //If there's a bias.
                controller.setMode(AUTO_MODE);
                
                pwm_value = 0;                          //Init pwm_value
                temp_value = 0;                         //Init temp_value
                time_value = 0;                         //Init time
                PWM.period_ms(1);                       //PWM output period
                button.fall(&pressed);                  //Pressed button interrupt
                PWM.write(0);                           //Heating desactivated

                while(1){
                          temp_value = LM35.read();         //LM35 value reading
                          temp_value = temp_value * 330 ;   //Conversion in °C
                          controller.setProcessValue(temp_value); //Set the new output.
                          pwm_value = controller.compute();
                          pc.printf("Time = %i/ Temp = %f/ PWM = %f\n", time_value, temp_value, pwm_value);
                          time_value++;                     // incrément de time_value
                          PWM.write(pwm_value);
                          wait(pid_time);
                        
                        }
            }
*/            